<?php
// archivo get_pieAnaEstDesGloHabDanChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir la(s) tabla(s) a consultar
$tables = [
  ['name' => 'danza_expresion_corporal']
  // Puedes agregar más tablas aquí si es necesario.
];

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Arreglos para acumular los datos por modalidad
$dataCoordinacion   = [];
$dataEquilibrio     = [];
$dataControl        = [];
$dataEspontaneidad  = [];
$dataCreatividad    = [];

foreach ($tables as $table) {
    $tableName = $table['name'];
    $sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, 
                   SUM(puntaje_coordinacion) AS total_coordinacion, 
                   SUM(puntaje_equilibrio) AS total_equilibrio, 
                   SUM(puntaje_control_corporal) AS total_control,
                   SUM(puntaje_espontaneidad) AS total_espontaneidad,
                   SUM(puntaje_creatividad) AS total_creatividad

            FROM $tableName
            GROUP BY modality";
    $result = $conn->query($sql);
    while ($row = $result->fetch_assoc()){
        $mod = $row['modality'];
        $modNormalized = removeAccents($mod);
        // Si la modalidad normalizada no está en las específicas, agruparla como "ninguna"
        if (!in_array($modNormalized, $modalitiesSpecific)) {
            $modNormalized = "ninguna";
        }
        // Acumular puntaje de coordinación
        if (!isset($dataCoordinacion[$modNormalized])) {
            $dataCoordinacion[$modNormalized] = 0;
        }
        $dataCoordinacion[$modNormalized] += (int)$row['total_coordinacion'];
        
        // Acumular puntaje de equilibrio
        if (!isset($dataEquilibrio[$modNormalized])) {
            $dataEquilibrio[$modNormalized] = 0;
        }
        $dataEquilibrio[$modNormalized] += (int)$row['total_equilibrio'];

        // Acumular puntaje de control corporal
        if (!isset($dataControl[$modNormalized])) {
            $dataControl[$modNormalized] = 0;
        }
        $dataControl[$modNormalized] += (int)$row['total_control'];
        
        // Acumular puntaje de espontaneidad
        if (!isset($dataEspontaneidad[$modNormalized])) {
            $dataEspontaneidad[$modNormalized] = 0;
        }
        $dataEspontaneidad[$modNormalized] += (int)$row['total_espontaneidad'];

        // Acumular puntaje de creatividad
        if (!isset($dataCreatividad[$modNormalized])) {
            $dataCreatividad[$modNormalized] = 0;
        }
        $dataCreatividad[$modNormalized] += (int)$row['total_creatividad'];
    }
}
$conn->close();

// Preparar los arreglos de salida como arrays de objetos

$coordinacionData = [];
foreach ($dataCoordinacion as $modality => $total_coordinacion) {
    $coordinacionData[] = [
        'modality' => $modality,
        'total_coordinacion' => $total_coordinacion
    ];
}

$equilibrioData = [];
foreach ($dataEquilibrio as $modality => $total_equilibrio) {
    $equilibrioData[] = [
        'modality' => $modality,
        'total_equilibrio' => $total_equilibrio
    ];
}

$controlData = [];
foreach ($dataControl as $modality => $total_control) {
    $controlData[] = [
        'modality' => $modality,
        'total_control' => $total_control
    ];
}

$espontaneidadData = [];
foreach ($dataEspontaneidad as $modality => $total_espontaneidad) {
    $espontaneidadData[] = [
        'modality' => $modality,
        'total_espontaneidad' => $total_espontaneidad
    ];
}

$creatividadData = [];
foreach ($dataCreatividad as $modality => $total_creatividad) {
    $creatividadData[] = [
        'modality' => $modality,
        'total_creatividad' => $total_creatividad
    ];
}

// Se organiza la respuesta como un objeto con tres propiedades
$response = [
    'Coordinacion'   => $coordinacionData,
    'Equilibrio'     => $equilibrioData,
    'Control'   => $controlData,
    'Espontaneidad'     => $espontaneidadData,
    'Creatividad'     => $creatividadData
];

echo json_encode($response);
?>
