<?php
// archivo get_pieAnaEstDesGloHabDibPinChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir la(s) tabla(s) a consultar
$tables = [
  ['name' => 'dibujo_pintura']
  // Puedes agregar más tablas aquí si es necesario.
];

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Arreglos para acumular los datos por modalidad
$dataPrecision   = [];
$dataColores     = [];
$dataOrganizacion = [];

foreach ($tables as $table) {
    $tableName = $table['name'];
    $sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, 
                   SUM(puntaje_precision) AS total_precision, 
                   SUM(puntaje_colores) AS total_colores, 
                   SUM(puntaje_organizacion) AS total_organizacion
            FROM $tableName
            GROUP BY modality";
    $result = $conn->query($sql);
    while ($row = $result->fetch_assoc()){
        $mod = $row['modality'];
        $modNormalized = removeAccents($mod);
        // Si la modalidad normalizada no está en las específicas, agruparla como "ninguna"
        if (!in_array($modNormalized, $modalitiesSpecific)) {
            $modNormalized = "ninguna";
        }
        // Acumular puntaje de precisión
        if (!isset($dataPrecision[$modNormalized])) {
            $dataPrecision[$modNormalized] = 0;
        }
        $dataPrecision[$modNormalized] += (int)$row['total_precision'];
        
        // Acumular puntaje de colores
        if (!isset($dataColores[$modNormalized])) {
            $dataColores[$modNormalized] = 0;
        }
        $dataColores[$modNormalized] += (int)$row['total_colores'];
        
        // Acumular puntaje de organización
        if (!isset($dataOrganizacion[$modNormalized])) {
            $dataOrganizacion[$modNormalized] = 0;
        }
        $dataOrganizacion[$modNormalized] += (int)$row['total_organizacion'];
    }
}
$conn->close();

// Preparar los arreglos de salida como arrays de objetos

$precisionData = [];
foreach ($dataPrecision as $modality => $total_precision) {
    $precisionData[] = [
        'modality' => $modality,
        'total_precision' => $total_precision
    ];
}

$coloresData = [];
foreach ($dataColores as $modality => $total_colores) {
    $coloresData[] = [
        'modality' => $modality,
        'total_colores' => $total_colores
    ];
}

$organizacionData = [];
foreach ($dataOrganizacion as $modality => $total_organizacion) {
    $organizacionData[] = [
        'modality' => $modality,
        'total_organizacion' => $total_organizacion
    ];
}

// Se organiza la respuesta como un objeto con tres propiedades
$response = [
    'precision'   => $precisionData,
    'colores'     => $coloresData,
    'organizacion'=> $organizacionData
];

echo json_encode($response);
?>
