<?php
// archivo get_pieAnaEstDesGloHabEscModChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir la(s) tabla(s) a consultar
$tables = [
  ['name' => 'escultura_modelado']
  // Puedes agregar más tablas aquí si es necesario.
];

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Arreglos para acumular los datos por modalidad
$dataDestreza   = [];
$dataFuerza     = [];
$Coordinacion = [];

foreach ($tables as $table) {
    $tableName = $table['name'];
    $sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, 
                   SUM(puntaje_destreza) AS total_destreza, 
                   SUM(puntaje_fuerza) AS total_fuerza, 
                   SUM(puntaje_coordinacion) AS total_coordinacion
            FROM $tableName
            GROUP BY modality";
    $result = $conn->query($sql);
    while ($row = $result->fetch_assoc()){
        $mod = $row['modality'];
        $modNormalized = removeAccents($mod);
        // Si la modalidad normalizada no está en las específicas, agruparla como "ninguna"
        if (!in_array($modNormalized, $modalitiesSpecific)) {
            $modNormalized = "ninguna";
        }
        // Acumular puntaje de precisión
        if (!isset($dataDestreza[$modNormalized])) {
            $dataDestreza[$modNormalized] = 0;
        }
        $dataDestreza[$modNormalized] += (int)$row['total_destreza'];
        
        // Acumular puntaje de fuerza
        if (!isset($dataFuerza[$modNormalized])) {
            $dataFuerza[$modNormalized] = 0;
        }
        $dataFuerza[$modNormalized] += (int)$row['total_fuerza'];
        
        // Acumular puntaje de organización
        if (!isset($Coordinacion[$modNormalized])) {
            $Coordinacion[$modNormalized] = 0;
        }
        $Coordinacion[$modNormalized] += (int)$row['total_coordinacion'];
    }
}
$conn->close();

// Preparar los arreglos de salida como arrays de objetos

$destrezaData = [];
foreach ($dataDestreza as $modality => $total_destreza) {
    $destrezaData[] = [
        'modality' => $modality,
        'total_destreza' => $total_destreza
    ];
}

$fuerzaData = [];
foreach ($dataFuerza as $modality => $total_fuerza) {
    $fuerzaData[] = [
        'modality' => $modality,
        'total_fuerza' => $total_fuerza
    ];
}

$coordinacionData = [];
foreach ($Coordinacion as $modality => $total_coordinacion) {
    $coordinacionData[] = [
        'modality' => $modality,
        'total_coordinacion' => $total_coordinacion
    ];
}

// Se organiza la respuesta como un objeto con tres propiedades
$response = [
    'Destreza'   => $destrezaData,
    'Fuerza'     => $fuerzaData,
    'Coordinacion'=> $coordinacionData
];

echo json_encode($response);
?>
