<?php
// archivo get_pieAnaEstDesGloHabMusChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir la(s) tabla(s) a consultar
$tables = [
  ['name' => 'ritmo_tempo']
  // Puedes agregar más tablas aquí si es necesario.
];

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

// Arreglos para acumular los datos por modalidad
$dataRitmo   = [];
$dataTempo     = [];

foreach ($tables as $table) {
    $tableName = $table['name'];
    $sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, 
                   SUM(puntaje_ritmo) AS total_ritmo, 
                   SUM(puntaje_tempo) AS total_tempo
            FROM $tableName
            GROUP BY modality";
    $result = $conn->query($sql);
    while ($row = $result->fetch_assoc()){
        $mod = $row['modality'];
        $modNormalized = removeAccents($mod);
        // Si la modalidad normalizada no está en las específicas, agruparla como "ninguna"
        if (!in_array($modNormalized, $modalitiesSpecific)) {
            $modNormalized = "ninguna";
        }
        // Acumular puntaje de precisión
        if (!isset($dataRitmo[$modNormalized])) {
            $dataRitmo[$modNormalized] = 0;
        }
        $dataRitmo[$modNormalized] += (int)$row['total_ritmo'];
        
        // Acumular puntaje de tempo
        if (!isset($dataTempo[$modNormalized])) {
            $dataTempo[$modNormalized] = 0;
        }
        $dataTempo[$modNormalized] += (int)$row['total_tempo'];
    }
}
$conn->close();

// Preparar los arreglos de salida como arrays de objetos

$ritmoData = [];
foreach ($dataRitmo as $modality => $total_ritmo) {
    $ritmoData[] = [
        'modality' => $modality,
        'total_ritmo' => $total_ritmo
    ];
}

$tempoData = [];
foreach ($dataTempo as $modality => $total_tempo) {
    $tempoData[] = [
        'modality' => $modality,
        'total_tempo' => $total_tempo
    ];
}

// Se organiza la respuesta como un objeto con tres propiedades
$response = [
    'ritmo'   => $ritmoData,
    'tempo'     => $tempoData
];

echo json_encode($response);
?>
