<?php
// archivo get_pieAnaEstDesGlobIndCogTarAcaChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir las tablas a consultar
$tables = [
  ['name' => 'atencion_concentracion'],  // Sin tilde
  ['name' => 'resolucion_problemas'],
  ['name' => 'resultados_retencion']
];

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"  // Sin acento
];

$data = []; // Acumularemos los aciertos globales por modalidad

foreach ($tables as $table) {
    $tableName = $table['name'];
    $sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, SUM(aciertos) AS total_aciertos
            FROM $tableName
            GROUP BY modality";
    $result = $conn->query($sql);
    while ($row = $result->fetch_assoc()){
        $mod = $row['modality'];
        $modNormalized = removeAccents($mod);
        if (!in_array($modNormalized, $modalitiesSpecific)) {
            $modNormalized = "ninguna";
        }
        if (!isset($data[$modNormalized])) {
            $data[$modNormalized] = 0;
        }
        $data[$modNormalized] += (int)$row['total_aciertos'];
    }
}
$conn->close();

$pieData = [];
foreach ($data as $modality => $total_aciertos) {
    $pieData[] = [
        'modality' => $modality,
        'total_aciertos' => $total_aciertos
    ];
}
echo json_encode($pieData);
?>
