<?php
// archivo get_pieAnaEstDesResProChartData.php
header('Content-Type: application/json');
include 'db_config.php';

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Definir las tablas a consultar
$tableName = 'resolucion_problemas';

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"  // Sin acento
];

$data = []; // Acumularemos los aciertos globales por modalidad

// Modificamos el alias a "total_entries" para que coincida con lo que espera el JS
$sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, SUM(aciertos) AS total_entries
        FROM $tableName
        GROUP BY modality";
        
$result = $conn->query($sql);

while ($row = $result->fetch_assoc()){
    $mod = $row['modality'];
    $modNormalized = removeAccents($mod);
    // Si la modalidad normalizada no es una de las específicas, se asigna a "ninguna"
    if (!in_array($modNormalized, $modalitiesSpecific)) {
            if (strpos($modNormalized, 'aer') !== false) {
                $modNormalized = "aerobicos adaptados";
            } else {
                $modNormalized = "ninguna";
            }
        }
    if (!isset($data[$modNormalized])) {
        $data[$modNormalized] = 0;
    }
    $data[$modNormalized] += (int)$row['total_entries'];
}
$conn->close();

$pieData = [];
foreach ($data as $modality => $total_entries) {
    $pieData[] = [
        'modality' => $modality,
        'total_entries' => $total_entries
    ];
}
echo json_encode($pieData);
?>
