<?php
// archivo get_pieAnaEstHabVisChartData.php

// Activa la visualización de errores para depuración (quitar en producción)
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Permitir solicitudes desde cualquier origen (útil en desarrollo)
header('Access-Control-Allow-Origin: *');
header('Content-Type: application/json');

include 'db_config.php';

// Función para eliminar acentos
function removeAccents($string) {
    return iconv('UTF-8', 'ASCII//TRANSLIT', $string);
}

// Modalidades específicas (en minúsculas y sin acentos)
$modalitiesSpecific = [
    "baja intensidad y equilibrio",
    "resistencia moderada",
    "aerobicos adaptados"
];

$data = []; // Acumularemos los aciertos por modalidad

$sql = "SELECT LOWER(TRIM(modalidad_deporte)) AS modality, SUM(aciertos) AS total_entries
        FROM visuoespacial_results
        GROUP BY modality;";
$result = $conn->query($sql);

if (!$result) {
    echo json_encode(["error" => "Error en la consulta: " . $conn->error]);
    exit;
}

while ($row = $result->fetch_assoc()){
    $mod = $row['modality'];
    $modNormalized = removeAccents($mod);
    // Si la modalidad normalizada no está en las específicas, asignar "ninguna"
    if (!in_array($modNormalized, $modalitiesSpecific)) {
        $modNormalized = "ninguna";
    }
    if (!isset($data[$modNormalized])) {
        $data[$modNormalized] = 0;
    }
    $data[$modNormalized] += (int)$row['total_entries'];
}
$conn->close();

if (empty($data)) {
    echo json_encode(["error" => "No se encontraron registros en la tabla."]);
    exit;
}

$pieData = [];
foreach ($data as $modality => $total_entries) {
    $pieData[] = [
         "modality" => $modality,
         "total_entries" => $total_entries
    ];
}

echo json_encode($pieData);
?>
