<?php
// archivo get_pieHabArt_data.php

header('Content-Type: application/json');
include 'db_config.php';

$user_id = "";
if (isset($_GET['user_id']) || isset($_GET['id'])) {
    $user_id = $conn->real_escape_string(isset($_GET['id']) ? $_GET['id'] : $_GET['user_id']);
}

/**
 * Función para obtener los datos totales de un test.
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla.
 * @param string $aciertosColumn Nombre de la columna de aciertos.
 * @param string $testName Identificador del test.
 * @return array Datos totales.
 */
function getPieData(mysqli $conn, string $table, string $aciertosColumn, string $testName): array {
    global $user_id;
    
    $user_condition = "";
    if ($user_id !== "") {
        if ($table === "dibujo_pintura") {
            $user_condition = " WHERE documento_identidad = '$user_id' ";
        } else {
            $user_condition = " WHERE participant_id = '$user_id' ";
        }
    }
    
    $sql = "SELECT SUM($aciertosColumn) AS total_aciertos, COUNT(*) AS total_tests FROM $table $user_condition";
    $result = $conn->query($sql);
    if ($result && $row = $result->fetch_assoc()){
        return [
            'test'           => $testName,
            'total_aciertos' => (int)$row['total_aciertos'],
            'total_tests'    => (int)$row['total_tests']
        ];
    } else {
        error_log("Error en la consulta para $table: " . $conn->error);
        return [
            'test'           => $testName,
            'total_aciertos' => 0,
            'total_tests'    => 0
        ];
    }
}

$pieData = [];
$pieData[] = getPieData($conn, 'dibujo_pintura', 'puntaje_precision', 'Dibujo Precisión');
$pieData[] = getPieData($conn, 'dibujo_pintura', 'puntaje_colores', 'Dibujo Color');
$pieData[] = getPieData($conn, 'dibujo_pintura', 'puntaje_organizacion', 'Dibujo Organización');
$pieData[] = getPieData($conn, 'escultura_modelado', 'puntaje_destreza', 'Escultura Destreza');
$pieData[] = getPieData($conn, 'escultura_modelado', 'puntaje_fuerza', 'Escultura Fuerza');
$pieData[] = getPieData($conn, 'escultura_modelado', 'puntaje_coordinacion', 'Escultura Coordinación');
$pieData[] = getPieData($conn, 'ritmo_tempo', 'puntaje_ritmo', 'Musica Ritmo');
$pieData[] = getPieData($conn, 'ritmo_tempo', 'puntaje_tempo', 'Musica Tempo');
$pieData[] = getPieData($conn, 'danza_expresion_corporal', 'puntaje_coordinacion', 'Danza Coordinación');
$pieData[] = getPieData($conn, 'danza_expresion_corporal', 'puntaje_equilibrio', 'Danza Equilibrio');
$pieData[] = getPieData($conn, 'danza_expresion_corporal', 'puntaje_control_corporal', 'Danza Control');
$pieData[] = getPieData($conn, 'danza_expresion_corporal', 'puntaje_espontaneidad', 'Danza Expontaneidad');
$pieData[] = getPieData($conn, 'danza_expresion_corporal', 'puntaje_creatividad', 'Danza Creatividad');
$pieData[] = getPieData($conn, 'expresion_teatral', 'puntaje_expresion', 'Teatro Expresión');
$pieData[] = getPieData($conn, 'expresion_teatral', 'puntaje_proyectar_voz', 'Teatro Proyección Voz');
$pieData[] = getPieData($conn, 'expresion_teatral', 'puntaje_control_corporal', 'Teatro Corporalidad');
$pieData[] = getPieData($conn, 'expresion_teatral', 'puntaje_modular_tonos', 'Teatro Tonos');
$pieData[] = getPieData($conn, 'expresion_teatral', 'puntaje_articulacion', 'Teatro Articulación');

// Calcular el total global de aciertos
$totalAciertosGlobal = 0;
foreach ($pieData as $dataItem) {
    $totalAciertosGlobal += $dataItem['total_aciertos'];
}

foreach ($pieData as &$dataItem) {
    if ($totalAciertosGlobal > 0) {
        $dataItem['percentage'] = round(($dataItem['total_aciertos'] * 100) / $totalAciertosGlobal, 2);
    } else {
        $dataItem['percentage'] = 0;
    }
}
unset($dataItem);

echo json_encode($pieData);
?>
