<?php
// archivo get_pieIndHabArt_data.php

header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Obtener el ID del usuario (usando 'id' o 'user_id')
$user_id = "";
if (isset($_GET['user_id']) || isset($_GET['id'])) {
    $user_id = $conn->real_escape_string($_GET['id'] ?? $_GET['user_id']);
}

error_log("Valor recibido de user_id (HabArt): " . $user_id);

if (empty($user_id)) {
    error_log("No se proporcionó un ID de usuario válido.");
    echo json_encode([]);
    exit();
}

/**
 * Función para obtener los datos totales de un test (área artística).
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla.
 * @param string $scoreColumn Nombre de la columna de score.
 * @param string $testName Identificador del test (área artística).
 * @param string $user_id ID del usuario.
 * @return array Datos totales.
 */
function getPieData(mysqli $conn, string $table, string $scoreColumn, string $testName, string $user_id): array {
    $sql = "SELECT SUM($scoreColumn) AS total_score, COUNT(*) AS total_tests 
            FROM $table 
            WHERE participant_id = '$user_id'";
    error_log("Consulta ejecutada (HabArt): $sql");

    $result = $conn->query($sql);
    
    if ($result && $row = $result->fetch_assoc()){
        return [
            'test'           => $testName,
            'total_score'    => (int)$row['total_score'],
            'total_tests'    => (int)$row['total_tests']
        ];
    } else {
        error_log("Error en la consulta para $table: " . $conn->error);
        return [
            'test'           => $testName,
            'total_score'    => 0,
            'total_tests'    => 0
        ];
    }
}

$pieData = [];
$pieData[] = getPieData($conn, 'dibujo_pintura', 'puntaje_precision', 'Dibujo y Pintura', $user_id);
$pieData[] = getPieData($conn, 'escultura_modelado', 'puntaje_destreza', 'Escultura y Modelado', $user_id);
$pieData[] = getPieData($conn, 'ritmo_tempo', 'puntaje_ritmo', 'Ritmo y Tempo', $user_id);
$pieData[] = getPieData($conn, 'danza_expresion_corporal', 'puntaje_coordinacion', 'Danza y Expresión Corporal', $user_id);
$pieData[] = getPieData($conn, 'expresion_teatral', 'puntaje_expresion', 'Expresión Teatral', $user_id);

$totalScoreGlobal = array_reduce($pieData, function($carry, $item) {
    return $carry + $item['total_score'];
}, 0);

foreach ($pieData as &$dataItem) {
    $dataItem['percentage'] = ($totalScoreGlobal > 0) ? round(($dataItem['total_score'] * 100) / $totalScoreGlobal, 2) : 0;
}
unset($dataItem);

error_log("Datos enviados (HabArt): " . json_encode($pieData));

echo json_encode($pieData);

?>
