<?php
// archivo get_pieIndHabDan_data.php

header('Content-Type: application/json');
include 'db_config.php';

$user_id = "";
if (isset($_GET['user_id']) || isset($_GET['id'])) {
    $user_id = $conn->real_escape_string(isset($_GET['id']) ? $_GET['id'] : $_GET['user_id']);
}

/**
 * Función para obtener los datos totales de un test.
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla.
 * @param string $aciertosColumn Nombre de la columna de aciertos.
 * @param string $testName Identificador del test.
 * @return array Datos totales.
 */
function getPieData(mysqli $conn, string $table, string $aciertosColumn, string $testName): array {
    global $user_id;
    
    $user_condition = "";
    if (!empty($user_id)) {
        if ($table === "danza_expresion_corporal") {
            $user_condition = " WHERE documento_identidad = '$user_id' ";
        } else {
            $user_condition = " WHERE participant_id = '$user_id' ";
        }
    }
    $sql = "SELECT SUM($aciertosColumn) AS total_aciertos, COUNT(*) AS total_tests 
        FROM $table 
        WHERE participant_id = '$user_id'";
    
    $result = $conn->query($sql);
    
    if ($result && $row = $result->fetch_assoc()) {
        return [
            'test'           => $testName,
            'total_aciertos' => (int)$row['total_aciertos'],
            'total_tests'    => (int)$row['total_tests']
        ];
    } else {
        error_log("Error en la consulta para $table: " . $conn->error);
        return [
            'test'           => $testName,
            'total_aciertos' => 0,
            'total_tests'    => 0
        ];
    }
}

$pieData = [];
$pieData[] = getPieData($conn, 'danza_expresion_corporal', 'puntaje_coordinacion', 'Danza Coordinación');
$pieData[] = getPieData($conn, 'danza_expresion_corporal', 'puntaje_equilibrio', 'Danza Equilibrio');
$pieData[] = getPieData($conn, 'danza_expresion_corporal', 'puntaje_control_corporal', 'Danza Control Corporal');
$pieData[] = getPieData($conn, 'danza_expresion_corporal', 'puntaje_espontaneidad', 'Danza Espontaneidad');
$pieData[] = getPieData($conn, 'danza_expresion_corporal', 'puntaje_creatividad', 'Danza Creatividad');

// Calcular el total global de aciertos
$totalAciertosGlobal = array_sum(array_column($pieData, 'total_aciertos'));

// Agregar el porcentaje para cada test
foreach ($pieData as &$data) {
    $data['percentage'] = ($totalAciertosGlobal > 0) ? round(($data['total_aciertos'] * 100) / $totalAciertosGlobal, 2) : 0;
}
unset($data); // Limpiar la referencia

echo json_encode($pieData);
?>
