<?php
// archivo get_pieIndIndCogTarAca_data.php

header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Obtener el ID del usuario (usando 'id' o 'user_id')
$user_id = "";
if (isset($_GET['user_id']) || isset($_GET['id'])) {
    $user_id = $conn->real_escape_string($_GET['id'] ?? $_GET['user_id']);
}

error_log("Valor recibido de user_id (IndIndCogTarAca Pie): " . $user_id);

if (empty($user_id)) {
    error_log("No se proporcionó un ID de usuario válido (IndIndCogTarAca Pie).");
    echo json_encode([]);
    exit();
}

/**
 * Función para obtener los datos totales de un test.
 *
 * @param mysqli $conn Conexión a la BD.
 * @param string $table Nombre de la tabla.
 * @param string $aciertosColumn Nombre de la columna de aciertos.
 * @param string $testName Identificador del test.
 * @param string $user_id ID del usuario.
 * @return array Datos totales.
 */
function getPieData(mysqli $conn, string $table, string $aciertosColumn, string $testName, string $user_id): array {
    $sql = "SELECT SUM($aciertosColumn) AS total_aciertos, COUNT(*) AS total_tests 
            FROM $table 
            WHERE participant_id = '$user_id'";
    error_log("Consulta ejecutada (IndIndCogTarAca Pie): $sql");

    $result = $conn->query($sql);
    
    if ($result && $row = $result->fetch_assoc()){
        return [
            'test'           => $testName,
            'total_aciertos' => (int)$row['total_aciertos'],
            'total_tests'    => (int)$row['total_tests']
        ];
    } else {
        error_log("Error en la consulta para $table: " . $conn->error);
        return [
            'test'           => $testName,
            'total_aciertos' => 0,
            'total_tests'    => 0
        ];
    }
}

$pieData = [];
$pieData[] = getPieData($conn, 'atencion_concentracion', 'aciertos', 'Atención y Concentración', $user_id);
$pieData[] = getPieData($conn, 'resolucion_problemas', 'aciertos', 'Resolución de Problemas', $user_id);
$pieData[] = getPieData($conn, 'resultados_retencion', 'aciertos', 'Retención de Información', $user_id);

$totalAciertosGlobal = array_reduce($pieData, function($carry, $item) {
    return $carry + $item['total_aciertos'];
}, 0);

foreach ($pieData as &$dataItem) {
    $dataItem['percentage'] = ($totalAciertosGlobal > 0) ? round(($dataItem['total_aciertos'] * 100) / $totalAciertosGlobal, 2) : 0;
}
unset($dataItem);

error_log("Datos enviados (IndIndCogTarAca Pie): " . json_encode($pieData));

echo json_encode($pieData);
?>
