<?php
// archivo get_pieIndObsReg_data.php
header('Content-Type: application/json');
include 'db_config.php';

// Filtrar por usuario (ID del participante)
$user_id = "";
if (isset($_GET['user_id']) || isset($_GET['id'])) {
    $user_id = $conn->real_escape_string(isset($_GET['id']) ? $_GET['id'] : $_GET['user_id']);
}

/**
 * Función para obtener los datos totales de una pregunta (test) de evaluacion_impacto.
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla.
 * @param string $aciertosColumn Columna que contiene los valores de la pregunta.
 * @param string $testName Identificador del test.
 * @return array Datos totales.
 */
function getPieData(mysqli $conn, string $table, string $aciertosColumn, string $testName): array {
    global $user_id;
    // Se añade condición para filtrar por participant_id
     $user_condition = "";
    if (!empty($user_id)) {
        $user_condition = "WHERE participant_id = '$user_id'";
    }
    $sql = "SELECT SUM($aciertosColumn) AS total_aciertos, COUNT(*) AS total_tests 
            FROM $table 
            $user_condition";
    $result = $conn->query($sql);
    if ($result && $row = $result->fetch_assoc()){
        return [
            'test'           => $testName,
            'total_aciertos' => (int)$row['total_aciertos'],
            'total_tests'    => (int)$row['total_tests']
        ];
    } else {
        error_log("Error en la consulta para $table: " . $conn->error);
        return [
            'test'           => $testName,
            'total_aciertos' => 0,
            'total_tests'    => 0
        ];
    }
}

$pieData = [];
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta1', 'Participar Actividades Académicas');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta2', 'Atención en Clases');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta3', 'Reacción ante Tareas Desafiantes');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta4', 'Interés por Aprender');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta5', 'Colaboración con Compañeros');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta6', 'Actitud de Aprendizaje');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta7', 'Resolución de Problemas');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta8', 'Organización del Tiempo');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta9', 'Manejo de Emociones');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta10', 'Cumplimiento de Tareas');

// Calcular el total global de aciertos
$totalAciertosGlobal = 0;
foreach ($pieData as $dataItem) {
    $totalAciertosGlobal += $dataItem['total_aciertos'];
}

// Agregar el porcentaje para cada test
foreach ($pieData as &$dataItem) {
    $dataItem['percentage'] = $totalAciertosGlobal > 0 ? round(($dataItem['total_aciertos'] * 100) / $totalAciertosGlobal, 2) : 0;
}
unset($dataItem);

echo json_encode($pieData);
?>