<?php
// archivo get_pieIndObs_data.php

header('Content-Type: application/json');
include 'db_config.php';

/**
 * Función para obtener los datos totales de un test.
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla.
 * @param string $aciertosColumn Nombre de la columna de aciertos.
 * @param string $testName Identificador del test.
 * @return array Datos totales.
 */
function getPieData(mysqli $conn, string $table, string $aciertosColumn, string $testName): array {
    $sql = "SELECT SUM($aciertosColumn) AS total_aciertos, COUNT(*) AS total_tests FROM $table";
    $result = $conn->query($sql);
    if ($result && $row = $result->fetch_assoc()){
        return [
            'test'           => $testName,
            'total_aciertos' => (int)$row['total_aciertos'],
            'total_tests'    => (int)$row['total_tests']
        ];
    } else {
        error_log("Error en la consulta para $table: " . $conn->error);
        return [
            'test'           => $testName,
            'total_aciertos' => 0,
            'total_tests'    => 0
        ];
    }
}

$pieData = [];
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta1', 'Participar Actividades Academicas');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta2', 'Atención en Clases');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta3', 'Reaccióon Tareas desafiantes');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta4', 'Interes Aprender');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta5', 'Colaboración Comañeros');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta6', 'Actitud Aprendizaje');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta7', 'Resolución de Problemas');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta8', 'Organización Tiempo');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta9', 'Manejo Emociones');
$pieData[] = getPieData($conn, 'evaluacion_impacto', 'pregunta10', 'Cumple Tareas');

// Calcular el total global de aciertos
$totalAciertosGlobal = 0;
foreach ($pieData as $data) {
    $totalAciertosGlobal += $data['total_aciertos'];
}

// Agregar el porcentaje para cada test
foreach ($pieData as &$data) {
    if ($totalAciertosGlobal > 0) {
        $data['percentage'] = round(($data['total_aciertos'] * 100) / $totalAciertosGlobal, 2);
    } else {
        $data['percentage'] = 0;
    }
}
unset($data); // Limpiar la referencia

echo json_encode($pieData);
?>
