<?php
// archivo get_pieInd_data.php

header('Content-Type: application/json');
include 'db_config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Obtener el ID del usuario (ya sea por GET 'id' o 'user_id')
$user_id = "";
if (isset($_GET['user_id']) || isset($_GET['id'])) {
    $user_id = $conn->real_escape_string($_GET['id'] ?? $_GET['user_id']);
}

// Verificar el valor recibido
error_log("Valor recibido de user_id: " . $user_id);

// Si no se recibió un ID válido, devolver un JSON vacío
if (empty($user_id)) {
    error_log("No se proporcionó un ID de usuario válido.");
    echo json_encode([]);
    exit();
}

/**
 * Función para obtener los datos totales de un test.
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla.
 * @param string $aciertosColumn Columna de aciertos.
 * @param string $testName Identificador del test.
 * @param string $user_id ID del usuario.
 * @return array Datos totales.
 */
function getPieData(mysqli $conn, string $table, string $aciertosColumn, string $testName, string $user_id): array {
    $sql = "SELECT SUM($aciertosColumn) AS total_aciertos, COUNT(*) AS total_tests 
            FROM $table 
            WHERE participant_id = '$user_id'";
    error_log("Consulta ejecutada: $sql");

    $result = $conn->query($sql);
    
    if ($result && $row = $result->fetch_assoc()){
        return [
            'test'           => $testName,
            'total_aciertos' => (int)$row['total_aciertos'],
            'total_tests'    => (int)$row['total_tests']
        ];
    } else {
        error_log("Error en la consulta para $table: " . $conn->error);
        return [
            'test'           => $testName,
            'total_aciertos' => 0,
            'total_tests'    => 0
        ];
    }
}

$pieData = [];
$pieData[] = getPieData($conn, 'test_entries', 'aciertos', 'Memoria Verbal', $user_id);
$pieData[] = getPieData($conn, 'funciones_ejecutivas', 'aciertos', 'Funciones Ejecutivas', $user_id);
$pieData[] = getPieData($conn, 'atencion_velocidad_procesamiento', 'aciertos', 'Atención Velocidad de Procesamiento', $user_id);
$pieData[] = getPieData($conn, 'visuoespacial_results', 'aciertos', 'Visuoespacial', $user_id);

// Calcular el total global de aciertos
$totalAciertosGlobal = array_reduce($pieData, function($carry, $item) {
    return $carry + $item['total_aciertos'];
}, 0);

// Agregar el porcentaje para cada test
foreach ($pieData as &$dataItem) {
    $dataItem['percentage'] = ($totalAciertosGlobal > 0) ? round(($dataItem['total_aciertos'] * 100) / $totalAciertosGlobal, 2) : 0;
}
unset($dataItem); // Limpiar referencia

// Depuración final antes de enviar datos
error_log("Datos enviados: " . json_encode($pieData));

echo json_encode($pieData);
?>
