<?php
header('Content-Type: application/json');
include 'db_config.php';

/**
 * Función para obtener los datos totales de un test.
 *
 * @param mysqli $conn Conexión a la base de datos.
 * @param string $table Nombre de la tabla.
 * @param string $aciertosColumn Nombre de la columna de aciertos.
 * @param string $testName Identificador del test.
 * @return array Datos totales.
 */
function getPieData(mysqli $conn, string $table, string $aciertosColumn, string $testName): array {
    $sql = "SELECT SUM($aciertosColumn) AS total_aciertos, COUNT(*) AS total_tests FROM $table";
    $result = $conn->query($sql);
    if ($result && $row = $result->fetch_assoc()){
        return [
            'test'           => $testName,
            'total_aciertos' => (int)$row['total_aciertos'],
            'total_tests'    => (int)$row['total_tests']
        ];
    } else {
        error_log("Error en la consulta para $table: " . $conn->error);
        return [
            'test'           => $testName,
            'total_aciertos' => 0,
            'total_tests'    => 0
        ];
    }
}

$pieData = [];
$pieData[] = getPieData($conn, 'test_entries', 'attempts', 'Memoria Verbal');
$pieData[] = getPieData($conn, 'funciones_ejecutivas', 'clasificaciones_correctas', 'Funciones Ejecutivas');
$pieData[] = getPieData($conn, 'atencion_velocidad_procesamiento', 'aciertos', 'Atención Velocidad de Procesamiento');
$pieData[] = getPieData($conn, 'visuoespacial_results', 'aciertos', 'Visoespacial');

// Calcular el total global de aciertos
$totalAciertosGlobal = 0;
foreach ($pieData as $data) {
    $totalAciertosGlobal += $data['total_aciertos'];
}

// Agregar el porcentaje para cada test
foreach ($pieData as &$data) {
    if ($totalAciertosGlobal > 0) {
        $data['percentage'] = round(($data['total_aciertos'] * 100) / $totalAciertosGlobal, 2);
    } else {
        $data['percentage'] = 0;
    }
}
unset($data); // Limpiar la referencia

echo json_encode($pieData);
?>
