<?php
// archivo guardar_logros.php
include 'db_config.php';

// Obtener los datos del formulario
$nombreParticipante = isset($_POST['participant_name']) ? $_POST['participant_name'] : 'Sin nombre';
// Si se espera que el ID del participante venga por GET o se incluya como campo oculto, ajústalo según corresponda:
$documentoIdentidad = isset($_POST['id']) ? $_POST['id'] : ''; 
$modalidad = isset($_POST['modalidad_deporte']) ? $_POST['modalidad_deporte'] : 'ninguna';
$logro_academico = isset($_POST['logro_academico']) ? $_POST['logro_academico'] : '';
$logro_personal = isset($_POST['logro_personal']) ? $_POST['logro_personal'] : '';

// Preparar la consulta INSERT (asegúrate de que la columna "id" en la tabla "logros" sea la que deseas actualizar)
$query = "INSERT INTO logros (participant_name, id, modalidad_deporte, logro_academico, logro_personal) VALUES (?, ?, ?, ?, ?)";
$stmt = $conn->prepare($query);
if(!$stmt){
    die("Error en la preparación: " . $conn->error);
}
$stmt->bind_param("sssss", $nombreParticipante, $documentoIdentidad, $modalidad, $logro_academico, $logro_personal);
$stmt->execute();
$stmt->close();

// Redirigir a resumen_logros.php pasando el nombre del participante correctamente
header("Location: resumen_logros.php?participant_name=" . urlencode($nombreParticipante));
exit();
?>
