<?php
// archivo guardar_resultados3.php
include 'db_config.php';
// No es recomendable incluir index.php si este genera salida HTML
 include 'index3.php';

// Crear conexión a la base de datos
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Conexión fallida: " . $conn->connect_error);
}

// Verificar si los datos llegaron correctamente
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Obtener datos del formulario
    $correctCount = isset($_POST['correct']) ? $_POST['correct'] : 0; // Número de aciertos
    $participantName = isset($_POST['participant_name']) ? $_POST['participant_name'] : '';
    $modalidadDeporte = isset($_POST['modalidad_deporte']) ? $_POST['modalidad_deporte'] : '';
    $documentoIdentidad = isset($_POST['documento_identidad']) ? $_POST['documento_identidad'] : '';

    // Comprobar si ya existe un registro previo para el usuario
    $queryCheck = "SELECT * FROM funciones_ejecutivas WHERE documento_identidad = ? ORDER BY fecha_registro DESC LIMIT 1";
    $stmtCheck = $conn->prepare($queryCheck);
    if (!$stmtCheck) {
        die("Error en prepare (check): " . $conn->error);
    }
    $stmtCheck->bind_param("s", $documentoIdentidad);
    $stmtCheck->execute();
    $result = $stmtCheck->get_result();

    $esSeguimiento = $result->num_rows > 0; // Verifica si es seguimiento
    $anteriorResultado = null;

    if ($esSeguimiento) {
        $registroAnterior = $result->fetch_assoc();
        $anteriorResultado = $registroAnterior['aciertos'];
    }

    // Generar texto para "resultado"
    $resultadoTexto = "";
    if (!$esSeguimiento) {
        $resultadoTexto = "El resultado obtenido en el test inicial de funciones ejecutivas fue $correctCount.";
    } else {
        if ($correctCount > $anteriorResultado) {
            $resultadoTexto = "Comparativamente con el test de funciones ejecutivas anterior, hubo mejoría.";
        } elseif ($correctCount < $anteriorResultado) {
            $resultadoTexto = "Comparativamente con el test de funciones ejecutivas anterior, empeoró.";
        } else {
            $resultadoTexto = "Comparativamente con el test de funciones ejecutivas anterior, permaneció igual.";
        }
    }

    // Generar recomendaciones basadas en la actividad física
    $recomendacionesTexto = "";
    if ($modalidadDeporte !== "no participa de la investigacion") {
        $recomendacionesTexto .= "Se recomienda continuar con la modalidad de actividad física $modalidadDeporte. ";
        $recomendacionesTexto .= "Adicionalmente, realizar ejercicios específicos que fortalezcan la funciones ejecutivas.";
    } else {
        $recomendacionesTexto .= "Para mejorar el desempeño de las funciones ejecutivas, considere estrategias cognitivas como la repetición espaciada, el uso de mapas mentales y ejercicios de atención.";
    }

    // Guardar los resultados en la base de datos
    $queryInsert = "INSERT INTO funciones_ejecutivas 
        (participant_name, documento_identidad, aciertos, modalidad_deporte, resultado, recomendaciones) 
        VALUES (?, ?, ?, ?, ?, ?)";
    $stmtInsert = $conn->prepare($queryInsert);
    if (!$stmtInsert) {
        die("Error en prepare (insert): " . $conn->error);
    }
    $stmtInsert->bind_param("ssisss", $participantName, $documentoIdentidad, $correctCount, $modalidadDeporte, $resultadoTexto, $recomendacionesTexto);

    if ($stmtInsert->execute()) {
        echo "";//Resultados guardados correctamente.
    } else {
        echo "Error al guardar los datos: " . $stmtInsert->error;
    }
} else {
    echo "No se ha enviado el formulario.";
}

$conn->close();
?>
<!-- Resumen del test para el usuario -->
<div class="test-summary-container">
    <h3 class="summary-title">Resumen del Test de Funciones Ejecutivas</h3>
    <div class="summary-box">
        <p><strong>Nombre del participante:</strong> <?= htmlspecialchars($participantName) ?></p>
        <p><strong>Modalidad de Deporte:</strong> <?= htmlspecialchars($modalidadDeporte) ?></p>
        <p><strong>Puntaje obtenido:</strong> <?= $correctCount ?> aciertos</p>
        <p><strong>Resultado:</strong> <?= $resultadoTexto ?></p>
        <p><strong>Recomendaciones:</strong> <?= $recomendacionesTexto ?></p>
    </div>
</div>
<style>
/* Contenedor principal del resumen */
.test-summary-container {
    max-width: 800px;
    margin: 30px auto;
    padding: 20px;
    background-color: #f9f9f9;
    border-radius: 10px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
}

/* Título del resumen */
.summary-title {
    text-align: center;
    font-size: 1.5rem;
    font-weight: bold;
    color: #333;
    margin-bottom: 20px;
}

/* Caja que contiene el resumen */
.summary-box {
    background-color: #fff;
    padding: 20px;
    border-radius: 8px;
    border: 1px solid #ddd;
    box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
}

/* Estilos para las etiquetas (labels) dentro del resumen */
.summary-box p {
    font-size: 1rem;
    line-height: 1.6;
    margin-bottom: 10px;
    color: #555;
}

/* Resaltar las etiquetas (strong) */
.summary-box strong {
    color: #007BFF;
    font-weight: 600;
}

/* Ajustes responsivos */
@media screen and (max-width: 768px) {
    .test-summary-container {
        padding: 15px;
    }

    .summary-title {
        font-size: 1.2rem;
    }

    .summary-box {
        padding: 15px;
    }
}
</style>
