<?php
// archivo habilidades_visoespaciales3.php 
include 'db_config.php';
include 'index3.php';


// Verificación de la versión de Python instalada (opcional)
echo shell_exec('python --version');

// Selección de una imagen aleatoria
$images = ['figura1.png', 'figura2.png', 'figura3.png', 'figura4.png', 'figura5.png', 'figura6.png', 'figura7.png', 'figura8.png', 'figura9.png', 'figura10.png'];
$imageToLoad = 'assets/reference_images/' . $images[array_rand($images)];

// Validación de los parámetros GET
$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$documentoIdentidad = isset($_GET['id']) ? $_GET['id'] : '';

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Evaluación Visuoespacial</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="container">
        <h1>Test de Evaluación Visuoespacial</h1>
        <p>Observa la figura a continuación y luego intenta dibujarla en una hoja aparte:</p>

        <!-- Imagen de referencia -->
        <img id="referenceImage" class="image-preview" src="<?= $imageToLoad ?>" alt="Figura de referencia">
<form id="" action="evaluate_drawing3.php" method="POST" enctype="multipart/form-data">
       <!-- Campo para nombre del participante -->
        <label for="participant_name">Nombre del Participante:</label>
        <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" required>

        <!-- Campo para número de documento -->
        <label for="id">Número de Identidad:</label>
        <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($documentoIdentidad ) ?>" required>

        <!-- Campo para modalidad de actividad física -->
        <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
        <select id="modalidad_deporte" name="modalidad_deporte">
            <option value="ninguna">Ninguna modalidad</option>
            <option value="baja intensidad y equilibrio">Ejercicios de baja intensidad y equilibrio</option>
            <option value="resistencia moderada">Ejercicios de resistencia moderada</option>
            <option value="aerobicos adaptados">Ejercicios aeróbicos adaptados</option>
        </select><br><br>

        <!-- Formulario de calificación -->
        
            <label for="aciertos">Califica el dibujo:</label>
            <input type="number" name="aciertos" id="aciertos" required title="Califique de 1 a 5 la calidad del dibujo, siendo 1 la nota mas baja y 5 la maxima.">

            <br>
            <button type="submit">Evaluar</button>
        </form><br><br>

        <div id="result"></div>
    </div>

</body>
</html>