<?php
// informe_desempeno.php

include 'db_config.php';  // Archivo de conexión a la base de datos
include 'encabezado2.php';  // Si este archivo incluye un encabezado o menús

// Consulta para obtener la lista de beneficiarios
$sql_beneficiarios = "SELECT * FROM beneficiarios";
$result_beneficiarios = $conn->query($sql_beneficiarios);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Beneficiarios para Informe de Desempeño</title>
    <style>
        .beneficiario-container {
            margin-bottom: 20px;
            border: 1px solid #ccc;
            padding: 10px;
            width: 300px;
            display: inline-block;
            vertical-align: top;
            margin-right: 20px;
        }
        .beneficiario-photo {
            max-width: 150px;
            height: 150px;
        }
        .tarifa-input {
            width: 100%;
            padding: 8px;
            margin-top: 5px;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        .tarifa-submit {
            margin-top: 10px;
            background-color: #4CAF50;
            color: white;
            padding: 10px;
            border: none;
            cursor: pointer;
        }
        .tarifa-submit:hover {
            background-color: #45a049;
        }
        .readonly-input {
            background-color: #f1f1f1;
            border: none;
            color: #555;
        }
    </style>
</head>
<body>
    <h1>Lista de Beneficiarios - Generar Informe de Desempeño Escolar</h1><br>
    <h2>Ingrese el nombre de la institución antes de generar el informe en formato PDF</h2>

    <?php
    if ($result_beneficiarios->num_rows > 0) {
        while ($beneficiario = $result_beneficiarios->fetch_assoc()) {
            ?>
            <div class="beneficiario-container">
                <!-- Fotografía del beneficiario -->
                <?php
                $photo_path = "uploads/fotos/" . $beneficiario['fotografia'];
                if (!empty($beneficiario['fotografia']) && file_exists($photo_path)) {
                    echo "<img src='$photo_path' alt='Foto de {$beneficiario['nombre_completo']}' class='beneficiario-photo'>";
                } else {
                    echo "<p>No hay fotografía disponible.</p>";
                }
                ?>

                <!-- Nombre del beneficiario -->
                <h2><?php echo htmlspecialchars($beneficiario['nombre_completo']); ?></h2>

                <!-- Documento de identidad del beneficiario -->
                <p>Documento de Identidad: <?php echo htmlspecialchars($beneficiario['documento_identidad']); ?></p>

                <!-- Formulario para ingresar el nombre de la institución y generar el informe -->
                <form action="generate_informe_desempeno.php" method="POST" target="_blank">
                    <input type="hidden" name="beneficiario_id" value="<?php echo $beneficiario['id']; ?>">

                    <!-- Campo para ingresar el nombre de la institución -->
                    <label for="institucion_<?php echo $beneficiario['id']; ?>">Institución a la que va dirigido:</label>
                    <input type="text" id="institucion_<?php echo $beneficiario['id']; ?>" name="institucion_destino" class="tarifa-input" required placeholder="Ingrese la institución" title="Ingrese aquí el nombre de la institución o persona a la que va dirigido el documento" >

                    <button type="submit" class="tarifa-submit">Generar Informe PDF</button>
                </form>
            </div>
            <?php
        }
    } else {
        echo "<p>No hay beneficiarios registrados.</p>";
    }
    ?>
</body>
</html>

<?php
$conn->close();
?>
