<?php
// generar_reporte_comfenalco.php

include 'db_config.php';
include 'index.php';  // Si este archivo incluye un encabezado o menús

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Generar Informe Beneficiarios Comfenalco</title>
    <style>
        .seguimiento-menu {
            margin-top: 20px;
        }
        button {
            padding: 10px 20px;
            background-color: #4CAF50;
            color: white;
            border: none;
            cursor: pointer;
        }
        button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <h1>Generar Informe de Beneficiarios - Comfenalco</h1>
    <p>Seleccione la periodicidad para generar el informe en Excel de todos los beneficiarios cuya institución patrocinadora sea Comfenalco.</p>

    <!-- Selección de periodicidad -->
    <div class="seguimiento-menu">
        <label for="periodo">Seleccione la periodicidad:</label>
        <select id="periodo" name="periodo">
            <option value="">--Seleccione una evaluación--</option>
            <option value="mensual">Mensual</option>
            <option value="trimestral">Trimestral</option>
            <option value="semestral">Semestral</option>
            <option value="anual">Anual</option>
        </select>
        <br><br>
        <button onclick="generateExcelReport()">Generar Informe en Excel</button>
    </div>

    <script>
        function generateExcelReport() {
            const period = document.getElementById('periodo').value;
            if (period !== "") {
                // Abrir la generación del Excel en una nueva pestaña
                window.open('generate_excel_comfenalco.php?period=' + period, '_blank');
            } else {
                alert("Por favor, seleccione un período.");
            }
        }
    </script>
</body>
</html>
