<?php
// list_beneficiarios2.php

include 'db_config.php';
include 'encabezado2.php';

// Consulta para obtener la lista de alumnos
$sql_beneficiarios = "SELECT * FROM beneficiarios";
$result_beneficiarios = $conn->query($sql_beneficiarios);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!--link rel="stylesheet" href="css/styles.css"--> <!-- Asegúrate que la ruta sea correcta -->
    <title>Lista de Beneficiarios y sus Seguimientos</title>
    <style>
        .beneficiario-container {
            margin-bottom: 20px;
            border: 1px solid #ccc;
            padding: 10px;
            width: 300px;
            display: inline-block;
            vertical-align: top;
            margin-right: 20px;
        }
        .beneficiario-photo {
            max-width: 150px;
            height: 150px;
        }
        .seguimiento-menu {
            margin-top: 10px;
        }
    </style>
    <script>
        function generateReport(beneficiario_Id, period) {
            if (period !== "") {
                // Abrir la generación del PDF en una nueva pestaña
                window.open('generate_pdf.php?beneficiario_id=' + beneficiario_Id + '&period=' + period, '_blank');
            }
        }
    </script>
</head>
<body>
    <h1>Lista de Beneficiarios y sus Seguimientos</h1><br>
    <h1>para generar informe en formato PDF</h1>

    <?php
    if ($result_beneficiarios->num_rows > 0) {
        while ($beneficiario = $result_beneficiarios->fetch_assoc()) {
            ?>
            <div class="beneficiario-container">
                <!-- Fotografía del estudiante -->
                <?php
                $photo_path = "uploads/fotos/" . $beneficiario['fotografia'];
                if (!empty($beneficiario['fotografia']) && file_exists($photo_path)) {
                    echo "<img src='$photo_path' alt='Foto de {$beneficiario['nombre_completo']}' class='beneficiario-photo'>";
                } else {
                    echo "<p>No hay fotografía disponible.</p>";
                }
                ?>

                <!-- Nombre del estudiante -->
                <h2><?php echo htmlspecialchars($beneficiario['nombre_completo']); ?></h2>

                <!-- Menú desplegable de evaluaciones -->
                <div class="seguimiento-menu">
                    <label for="seguimiento_<?php echo $beneficiario['id']; ?>"> <!--Aqui se puede poner un aviso que se visualisara  --> </label>
                    <select id="seguimiento_<?php echo $beneficiario['id']; ?>" onchange="generateReport(<?php echo $beneficiario['id']; ?>, this.value)" title="Haga una selección para generar el reporte en formato PDF" >
                        <option value="" title="Haga una selección para generar el reporte en formato PDF" >--Seleccione una evaluación--</option>
                        <option value="ultima">Último Seguimiento</option>
                        <option value="mensual">Seguimientos del Último Mes</option>
                        <option value="trimestral">Seguimientos del Último Trimestre</option>
                        <option value="semestral">Seguimientos del Último Semestre</option>
                        <option value="anual">Seguimientos del Año</option>
                    </select>
                </div>
            </div>
            <?php
        }
    } else {
        echo "<p>No hay beneficiarios registrados.</p>";
    }
    ?>

</body><br><br><br>
</html>