<?php
// archivo insertarUsuarios.php

// Incluir la configuración de la base de datos
include 'db_config.php';

// Comprobar si el formulario ha sido enviado
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Recibir y limpiar los datos del formulario de registro
    $nombre = isset($_POST['nombre']) ? trim($_POST['nombre']) : '';
    $clave = isset($_POST['clave']) ? $_POST['clave'] : '';
    $confirmar_clave = isset($_POST['confirmar']) ? $_POST['confirmar'] : '';
    $tipo_usuario = isset($_POST['tipo_usuario']) ? intval($_POST['tipo_usuario']) : 2;

    // Verificar que los campos obligatorios no estén vacíos
    if (empty($nombre) || empty($clave) || empty($confirmar_clave)) {
        echo "<script>alert('Por favor, complete todos los campos.'); window.location.href = 'registro_usuarios.php';</script>";
        exit();
    }

    // Verificar si las contraseñas coinciden
    if ($clave !== $confirmar_clave) {
        echo "<script>alert('Las contraseñas no coinciden.'); window.location.href = 'registro_usuarios.php';</script>";
        exit();
    }
    
    // Opcional: aplicar hash a la contraseña (muy recomendable)
    $claveHash = password_hash($clave, PASSWORD_DEFAULT);

    // Verificar si el usuario ya existe
    $sql = "SELECT * FROM usuarios WHERE nombre = ?";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        echo "<script>alert('Error en la consulta.'); window.location.href = 'registro_usuarios.php';</script>";
        exit();
    }
    $stmt->bind_param("s", $nombre);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Si el usuario ya está registrado
        echo "<script>alert('El usuario ya está registrado.'); window.location.href = 'registro_usuarios.php';</script>";
        exit();
    } else {
        // Insertar el nuevo usuario en la base de datos
        $sql_insert = "INSERT INTO usuarios (nombre, clave, tipo_usuario) VALUES (?, ?, ?)";
        $stmt_insert = $conn->prepare($sql_insert);
        if (!$stmt_insert) {
            echo "<script>alert('Error al preparar la inserción.'); window.location.href = 'registro_usuarios.php';</script>";
            exit();
        }
        $stmt_insert->bind_param("ssi", $nombre, $claveHash, $tipo_usuario);

        if ($stmt_insert->execute()) {
            echo "<script>alert('Registro exitoso. Ahora puede iniciar sesión.'); window.location.href = 'registro_usuarios.php';</script>";
        } else {
            echo "<script>alert('Error al registrar el usuario.'); window.location.href = 'registro_usuarios.php';</script>";
        }

        $stmt_insert->close();
    }

    $stmt->close();
    $conn->close();
} else {
    echo "<script>alert('Acción no válida.'); window.location.href = 'registro_usuarios.php';</script>";
    exit();
}
?>
