<?php 
include 'db_config.php';
include 'index.php';
//include "estilos"; // este archivo crea interferencias con este codigo 
// Obtener la lista de Beneficiarios
$sql = "SELECT id, nombre_completo, fotografia FROM beneficiarios";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Beneficiarios</title>
    <style>
        img {
            max-width: 150px;
            height: 150px;
            border-radius: 5px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <h1>Lista de Beneficiarios</h1>
    <ul> 
        <?php
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $base_url = 'http://localhost/Appsaubse_php/';
                $foto_path = !empty($row['fotografia']) ? $base_url . 'uploads/fotos/' . $row['fotografia'] : $base_url . 'uploads/fotos/default.jpg';

                // Mostrar el nombre del beneficiario, la imagen, y el enlace de edición
                echo "<li>";
               echo "<a href='registro_beneficiarios.php?beneficiario_id=" . $row['id'] . "'>";
                //echo "<a href='seguimiento_investigacion.php?beneficiario_id=" . $row['id'] . "'>";
                echo "Nombre del beneficiario: " ."<br>". htmlspecialchars($row['nombre_completo'], ENT_QUOTES, 'UTF-8') . "<br>";
                echo "<img src='" . htmlspecialchars($foto_path, ENT_QUOTES, 'UTF-8') . "' alt='Fotografía de " . htmlspecialchars($row['nombre_completo'], ENT_QUOTES, 'UTF-8') . "'>";
                echo "</a>";               
                // Agregar enlace de edición
                echo "<a href='editar_beneficiario.php?id=" . $row['id'] . "'>Editar Info.</a>";
                echo "</li>";
            }
        } else {
            echo "<p>No hay Beneficiarios registrados.</p>";
        }
        ?>
    </ul>
</body>
</html>
