<?php 
include 'db_config.php';
include 'index.php';

// Obtener la lista de Beneficiarios
$sql = "SELECT id, nombre_completo, fotografia FROM beneficiarios WHERE investigacion = si participa ";
$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Beneficiarios</title>
    <style>
        img {
            max-width: 150px;
            height: 150px;
            border-radius: 5px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <h1>Lista de Beneficiarios que participan en la investigacion</h1>
    <ul> 
        <?php
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                // Corregir la ruta base para las imágenes
                $base_url = 'http://localhost/Appsaubse_php/';
                $foto_path = !empty($row['fotografia']) ? $base_url . 'uploads/fotos/' . $row['fotografia'] : $base_url . 'uploads/fotos/default.jpg';

                // Depuración: mostrar la ruta generada
             /*   echo "<p>Ruta de la imagen generada: " . htmlspecialchars($foto_path, ENT_QUOTES, 'UTF-8') . "</p>";

                // Verifica si la imagen existe en el servidor usando una ruta absoluta
                $file_path = $_SERVER['DOCUMENT_ROOT'] . '/Appsaubse_php/uploads/fotos/' . $row['fotografia'];
                
                if (file_exists($file_path)) {
                    echo "<p>La imagen existe en el servidor.</p>";
                } else {
                    echo "<p>La imagen NO existe en el servidor. Verifique la ruta.</p>";
                } */
                
                // Mostrar el nombre del beneficiario y la imagen
                echo "<li>";
                echo "<a href='registro_beneficiarios.php?beneficiario_id=" . $row['id'] . "'>";
                echo "Nombre del beneficiario: " ."<br>". htmlspecialchars($row['nombre_completo'], ENT_QUOTES, 'UTF-8') . "<br>";
                echo "<img src='" . htmlspecialchars($foto_path, ENT_QUOTES, 'UTF-8') . "' alt='Fotografía de " . htmlspecialchars($row['nombre_completo'], ENT_QUOTES, 'UTF-8') . "'><br><br>";
                echo "</a></li>";
            }
        } else {
            echo "<p>No hay Beneficiarios registrados.</p>";
        }
        ?>
    </ul>
</body>
</html>
