<?php
// list_beneficiarios_certificados.php

include 'db_config.php';  // Archivo de conexión a la base de datos
include 'encabezado2.php';  // Si este archivo incluye un encabezado o menús

// Consulta para obtener la lista de beneficiarios
$sql_beneficiarios = "SELECT * FROM beneficiarios";
$result_beneficiarios = $conn->query($sql_beneficiarios);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Beneficiarios para Certificado de Discapacidad</title>
    <style>
        .beneficiario-container {
            margin-bottom: 20px;
            border: 1px solid #ccc;
            padding: 10px;
            width: 300px;
            display: inline-block;
            vertical-align: top;
            margin-right: 20px;
        }
        .beneficiario-photo {
            max-width: 150px;
            height: 150px;
        }
        a {
            text-decoration: none;
            color: #4CAF50;
            font-weight: bold;
        }
        a:hover {
            color: #45a049;
        }
    </style>
</head>
<body>
    <h1>Lista de Beneficiarios - Generar Certificado de Discapacidad</h1><br>
    <h1>Haga clic en el nombre para generar el certificado en formato PDF</h1>

    <?php
    if ($result_beneficiarios->num_rows > 0) {
        while ($beneficiario = $result_beneficiarios->fetch_assoc()) {
            ?>
            <div class="beneficiario-container">
                <!-- Fotografía del beneficiario -->
                <?php
                $photo_path = "uploads/fotos/" . $beneficiario['fotografia'];
                if (!empty($beneficiario['fotografia']) && file_exists($photo_path)) {
                    echo "<img src='$photo_path' alt='Foto de {$beneficiario['nombre_completo']}' class='beneficiario-photo'>";
                } else {
                    echo "<p>No hay fotografía disponible.</p>";
                }
                ?>

                <!-- Nombre del beneficiario como enlace -->
                <h2>
                    <a href="generate_certificado.php?beneficiario_id=<?php echo $beneficiario['id']; ?>" target="_blank">
                        <?php echo htmlspecialchars($beneficiario['nombre_completo']); ?>
                    </a>
                </h2>

                <!-- Documento de identidad del beneficiario -->
                <p>Documento de Identidad: <?php echo htmlspecialchars($beneficiario['documento_identidad']); ?></p>
            </div>
            <?php
        }
    } else {
        echo "<p>No hay beneficiarios registrados.</p>";
    }
    ?>
</body>
</html>

<?php
$conn->close();
?>
