<?php
// Archivo motivación_comportamiento3.php
include 'db_config.php';
include 'index3.php';

$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$documentoIdentidad = isset($_GET['id']) ? $_GET['id'] : ''; // ID del participante
$evaluacionTipo = '';

// Verificar si el participante ya tiene evaluaciones previas
if (!empty($nombreParticipante)) {
    $query = "SELECT COUNT(*) AS total FROM evaluacion_impacto WHERE participant_name = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("s", $nombreParticipante);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    
    if ($row['total'] > 0) {
        $evaluacionTipo = "Evaluación de Control del Progreso";
    } else {
        $evaluacionTipo = "Evaluación Inicial";
    }
    
    $stmt->close();
}

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Evaluación del Impacto de la Actividad Física</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 600px;
            margin: 20px auto;
            padding: 20px;
            border: 1px solid #ddd;
            border-radius: 8px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .form-group {
            margin-bottom: 15px;
        }
        label {
            display: block;
            margin-bottom: 5px;
        }
        select, input {
            width: 100%;
            padding: 8px;
            margin-bottom: 10px;
        }
        button {
            background-color: #4CAF50;
            color: white;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
        }
        .alert {
            padding: 10px;
            background-color: #f9f9f9;
            border-left: 4px solid #4CAF50;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>Evaluación del Impacto de la Actividad Física</h1>
    <?php if ($evaluacionTipo): ?>
        <div class="alert">
            <strong><?= htmlspecialchars($evaluacionTipo); ?>:</strong> Por favor, complete el formulario para continuar.
        </div>
    <?php endif; ?>
    <form action="save_evaluacion3.php" method="POST">
        <div class="form-group">
            <label for="participant_name">Nombre del Participante:</label>
            <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" required>
            <label for="participant_id">Número de Documento de Identidad:</label>
        <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($documentoIdentidad) ?>" required>
        </div>
        <div class="form-group">
           <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
            <select id="modalidad_deporte" name="modalidad_deporte" required>
                <option value="ninguna">Ninguna</option>
                <option value="baja intensidad y equilibrio">Baja intensidad y equilibrio</option>
                <option value="resistencia moderada">Resistencia moderada</option>
                <option value="aerobicos adaptados">Aeróbicos adaptados</option>
            </select>
        </div>
        <?php
        $preguntas = [
            "¿El estudiante muestra disposición a participar en actividades académicas?",
            "¿El estudiante mantiene la atención durante las clases?",
            "¿Cómo reacciona el estudiante ante tareas desafiantes?",
            "¿El estudiante muestra interés en aprender nuevos conceptos?",
            "¿El estudiante colabora eficazmente con sus compañeros?",
            "¿El estudiante demuestra una actitud positiva hacia el aprendizaje?",
            "¿El estudiante utiliza estrategias efectivas para resolver problemas?",
            "¿El estudiante organiza su tiempo adecuadamente en el aula?",
            "¿El estudiante maneja de manera adecuada las emociones negativas frente a las dificultades?",
            "¿El estudiante cumple con las tareas asignadas en tiempo y forma?"
        ];
        foreach ($preguntas as $index => $pregunta) {
            echo "
                <div class='form-group'>
                    <label>$pregunta</label>
                    <select name='pregunta" . ($index + 1) . "' required>
                        <option value='1'>1 - Nunca</option>
                        <option value='2'>2 - Raramente</option>
                        <option value='3'>3 - A veces</option>
                        <option value='4'>4 - Frecuentemente</option>
                        <option value='5'>5 - Siempre</option>
                    </select>
                </div>";
        }
        ?>
        <button type="submit">Enviar Evaluación</button>
    </form>
</div>
</body>
</html>
