<?php
// archivo plan_intervencion2.php
require_once 'db_config.php';
// Se elimina la inclusión de index.php para evitar interferencias
 include "encabezado2.php";

// Si se realiza una búsqueda, se filtran los beneficiarios por nombre
$searchTerm = '';
if (isset($_GET['search'])) {
    $searchTerm = $conn->real_escape_string($_GET['search']);
    $sql = "SELECT * FROM beneficiarios WHERE nombre_completo LIKE '%$searchTerm%'";
} else {
    $sql = "SELECT * FROM beneficiarios";
}

$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Gestión de Beneficiarios</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style>
        /* Estilos básicos para responsividad y presentación */
        body { font-family: Arial, sans-serif; margin: 0; padding: 20px; }
        .container { max-width: 1200px; margin: auto; }
        .header { display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; }
        .search-bar { margin: 20px 0; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        table, th, td { border: 1px solid #ccc; }
        th, td { padding: 10px; text-align: left; }
        img { max-width: 100%; height: auto; }
        .btn { padding: 8px 16px; margin-right: 5px; cursor: pointer; text-decoration: none; background-color: #007BFF; color: #fff; border: none; border-radius: 4px; }
        .btn:hover { background-color: #0056b3; }
        @media (max-width: 768px) {
            .header { flex-direction: column; }
        }
    </style>
</head>
<body>
<div class="container">
    <div class="header">
        <!--h1>Gestión de Beneficiarios</h1-->
        <div>
            <button class="btn" onclick="window.print();">Imprimir</button>
            <button class="btn btn-pdf" onclick="generatePDF()">Descargar PDF</button>
        </div>
    </div>
    
    <div class="search-bar">
        <form method="GET" action="plan_intervencion2.php">
            <input type="text" name="search" placeholder="Buscar por nombre..." value="<?php echo htmlspecialchars($searchTerm); ?>">
            <button type="submit" class="btn">Buscar</button>
        </form>
    </div>
    
    <!-- Listado de beneficiarios -->
    <?php if($result && $result->num_rows > 0): ?>
    <table id="chartsContainer">
        <thead>
            <tr>
                <th>Foto</th>
                <th>Nombre Completo</th>
                <th>Documento</th>
                <th>Grupo</th>
                <th>Sede</th>
                <th>Caja</th>
                <th>Diagnóstico</th>
                <th>Acciones</th>
                <!--th>Seguimientos</th-->
            </tr>
        </thead>
        <tbody>
        <?php while($row = $result->fetch_assoc()): ?>
            <tr> 
                <td>
                    <img src="uploads/fotos/<?php echo htmlspecialchars($row['fotografia']); ?>" alt="Foto de <?php echo htmlspecialchars($row['nombre_completo']); ?>" width="100">
                </td>
                <td><?php echo htmlspecialchars($row['nombre_completo']); ?></td>
                <td><?php echo htmlspecialchars($row['documento_identidad']); ?></td>
                <td><?php echo htmlspecialchars($row['grupo']); ?></td>
                <td><?php echo htmlspecialchars($row['sede']); ?></td>
                <td><?php echo htmlspecialchars($row['institucion_patrocinadora']); ?></td>
                <td><?php echo htmlspecialchars($row['diagnosis']); ?></td>
                <td>
                    <a href="view.php?id=<?php echo $row['id']; ?>" class="btn">Ver/Editar</a>
                </td>
                <!--td>
                    <a href="registro_beneficiarios.php?id=<?php echo $row['id']; ?>" class="btn">Seguimiento</a>
                </td-->
            </tr>
        <?php endwhile; ?>
        </tbody>
    </table>
    <?php else: ?>
        <p>No se encontraron beneficiarios.</p>
    <?php endif; ?>
</div>

<!-- jsPDF desde CDN para exportar a PDF -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>
<script>
     function generatePDF() {
      const { jsPDF } = window.jspdf;
      const doc = new jsPDF({ orientation: "scape", unit: "mm", format: "a4" });
      
      doc.setFontSize(12);
      doc.text("Sistema de Gestión de Beneficiarios" , 20, 20);
      
      const chartsContainer = document.getElementById("chartsContainer");
      html2canvas(chartsContainer, { scale: 1 }).then(canvas => {
        const imgData = canvas.toDataURL("image/png");
        const imgWidth = 200; // Ajusta el ancho de la imagen
        const imgHeight = 250;
        doc.addImage(imgData, "PNG", 1, 30, imgWidth, imgHeight);
        doc.save("gestion_beneficiarios.pdf");
      });
    }
</script>
</body>
</html>
