<?php
// archivo procesar_respuestas3.php
include 'db_config.php'; // Incluir la configuración de la base de datos
include "index3.php";

//session_start(); // Iniciar la sesión
//var_dump($_POST); // este codigo muestra cuales parametros se estan pasando en el formulario en el metodo POST

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$participant_name = $_POST['participant_name'] ?? ''; 
$modalidad_deporte = $_POST['modalidad_deporte'] ?? '';
$categoria = $_POST['categoria'] ?? '';
$dificultad = $_POST['dificultad'] ?? '';

$recomendaciones = "";

// Inicializamos variables para las respuestas
$aciertos = 0;
$total_preguntas = 5;

// Comenzamos el ciclo para comprobar las respuestas
for ($i = 1; $i <= $total_preguntas; $i++) {
    $respuesta_usuario = $_POST["respuesta_$i"];
    $respuesta_correcta = $_POST["respuesta_correcta_$i"];

    // Comprobamos si la respuesta del usuario es correcta
    if ($respuesta_usuario == $respuesta_correcta) {
        $aciertos++;
    }
}

// Generamos la recomendación basada en los aciertos
/*if ($aciertos == 5) {
    $recomendacion = "¡Excelente! Sigue así y alcanzarás grandes logros.";
} elseif ($aciertos >= 3) {
    $recomendacion = "Bien hecho, pero hay áreas en las que puedes mejorar. ¡Continúa practicando!";
} else {
    $recomendacion = "Necesitas mejorar en algunas áreas. Te recomendamos repasar los conceptos, practicar más ejercicios para mejorar tu estado.";
}

    if (strtolower($modalidad_deporte) !== 'no participa de la investigacion') {
        switch ($modalidad_deporte) {
            case 'baja intensidad y equilibrio':
                $recomendaciones .= " Además, los ejercicios de baja intensidad y equilibrio son ideales para ti.";
                break;
            case 'resistencia moderada':
                $recomendaciones .= " Los ejercicios de resistencia moderada son altamente beneficiosos para mejorar tu estado cognitivo.";
                break;
            case 'aeróbicos adaptados':
                $recomendaciones .= " Los ejercicios aeróbicos adaptados pueden ayudarte a mantener un mejor estado cognitivo.";
                break;
        }
    } else {
        $recomendaciones .= " No hay recomendaciones específicas sobre actividad física.";
    }*/

    //return $recomendaciones;


    // Generamos la recomendación basada en los aciertos
    $recomendaciones = $aciertos >= 4 ? "Excelente desempeño en el test de conocimientos, ¡Felicitaciones! Su desempeño demuestra un excelente trabajo, lo que se refleja en sus habilidades cognitivas." : ($aciertos >= 3 ? "desempeño adecuado en el test de conocimientos, Continúe trabajando para fortalecer sus habilidades cognitivas." : "Mejora necesaria, Se sugiere fuertemente poner mucho empeño con miras a mejorar estas habilidades cognitivas evaluadas en el test.");

    // Guardar datos en la base de datos
    $sql = "INSERT INTO resolucion_problemas 
              (participant_name, modalidad_deporte, categoria, dificultad, aciertos, preguntasSeleccionadas, recomendaciones) 
              VALUES (?, ?, ?, ?, ?, ?, ?)";

    if ($stmt = $conn->prepare($sql)) {
        $stmt->bind_param(
            "ssssiss",
            $participant_name,
            $modalidad_deporte,
            $categoria,
            $dificultad,
            $aciertos,
            $total_preguntas,
            $recomendaciones
        );

        if ($stmt->execute()) {
            echo ""; //¡Datos guardados correctamente!
        } else {
            echo "Error al guardar los datos: " . $stmt->error;
        }

        $stmt->close();
    } else {
        echo "Error en la consulta SQL: " . $conn->error;
    }

    $conn->close();

    // Mostrar el resumen del test al usuario
    echo "
            <div class='test-summary-container' > 
            <h3  class='summary-title'>Resumen del Test de Conocimientos en Matemáticas, Lógica y Ciencias</h3>
            <div class='summary-box'>
                <p><strong>Nombre del participante:</strong> $participant_name</p>
                <p><strong>Modalidad deportiva:</strong> $modalidad_deporte</p>
                <p><strong>Categoría:</strong> $categoria</p>
                <p><strong>Dificultad:</strong> $dificultad</p>
                <p><strong>Puntaje obtenido:</strong> $aciertos de $total_preguntas</p>
                <p><strong>Recomendaciones:</strong> $recomendaciones</p>
            </div>
          </div>";
    

    include "styleres.css";

    exit;
?>