<?php
// archivo reporte_estadistico_individual.php
include 'db_config.php';
include 'encabezado2.php';
include 'ver_bene_info_estadistico.php';

// Validar si se recibió el ID del beneficiario en la URL
if (!isset($_GET['beneficiario_id']) || empty($_GET['beneficiario_id'])) {
    die("Error: ID del beneficiario no especificado.");
}

$beneficiario_id = intval($_GET['beneficiario_id']); // Asegurar que sea un número entero

// Obtener la información del beneficiario de la base de datos
$sql_beneficiario = "SELECT nombre_completo, documento_identidad FROM beneficiarios WHERE id = ?";
$stmt = $conn->prepare($sql_beneficiario);
$stmt->bind_param("i", $beneficiario_id);
$stmt->execute();
$result_beneficiario = $stmt->get_result();

// Recuperar los datos del beneficiario
if ($row = $result_beneficiario->fetch_assoc()) {
    $nombreParticipante = htmlspecialchars($row['nombre_completo'], ENT_QUOTES, 'UTF-8');
    $documentoIdentidad = htmlspecialchars($row['documento_identidad'], ENT_QUOTES, 'UTF-8');
} else {
    die("Error: Beneficiario no encontrado.");
}

// Obtener la modalidad deportiva del beneficiario
$sql_modalidad = "SELECT modalidad_deporte FROM test_entries WHERE id = ?";
$stmt = $conn->prepare($sql_modalidad);
$stmt->bind_param("i", $beneficiario_id); // Se usa el ID correcto
$stmt->execute();
$result_modalidad = $stmt->get_result();

// Recuperar los datos de la modalidad deportiva
if ($row = $result_modalidad->fetch_assoc()) {
    $modalidad = htmlspecialchars($row['modalidad_deporte'], ENT_QUOTES, 'UTF-8');
} else {
    $modalidad = "No especificado"; // Evitar errores en caso de que no haya datos
}

$stmt->close();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sistema de Gestión de Investigación</title>
    <style>
        /* Estilos para el menú */
        ul { list-style-type: none; padding: 0; overflow: hidden; background-color: #333; }
        li { float: left; }
        li a, .dropbtn { display: inline-block; color: white; text-align: center; padding: 14px 16px; text-decoration: none; }
        li a:hover, .dropdown:hover .dropbtn { background-color: #111; }
        .dropdown { display: inline-block; }
        .dropdown-content { display: none; position: absolute; background-color: #f9f9f9; min-width: 200px; box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2); z-index: 1; }
        .dropdown-content a { color: black; padding: 12px 16px; text-decoration: none; display: block; text-align: left; }
        .dropdown-content a:hover { background-color: #f1f1f1; }
        .dropdown:hover .dropdown-content { display: block; }
    </style>
</head>
<body>
    <nav>
        <ul>
            <li><a href="analisis_estadistico_individual_rendimiento_cognitivo.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>&mod=<?= urlencode($modalidad) ?>">Gráficas Rendimiento Cognitivo</a></li>
            <li><a href="analisis_estadistico_individual_habilidades_academicas_basicas.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>&mod=<?= urlencode($modalidad) ?>">Gráficas Habilidades Académicas Básicas</a></li>
            <li><a href="analisis_estadistico_individual_indicadores_cognitivos_tareas_academicas.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>&mod=<?= urlencode($modalidad) ?>">Gráficas Indicadores en Tareas Académicas</a></li>
            <li><a href="analisis_estadistico_individual_observacion_registro.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>&mod=<?= urlencode($modalidad) ?>">Gráficas Habilidades y Actitudes para el Aprendizaje Efectivo</a></li>
            <li><a href="analisis_estadistico_individual_cuestionario_autoinforme.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>&mod=<?= urlencode($modalidad) ?>">Gráficas de Autopercepción</a></li>
            <li class="dropdown">
                <a href="analisis_estadistico_individual_habilidades_artes.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>&mod=<?= urlencode($modalidad) ?>">Gráficas de Habilidades en Artes</a>
                <div class="dropdown-content">
                    <a href="analisis_estadistico_individual_habilidades_dibujo_pintura.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>&mod=<?= urlencode($modalidad) ?>">Gráficas Dibujo y Pintura</a>
                    <a href="analisis_estadistico_individual_habilidades_escultura_modelado.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>&mod=<?= urlencode($modalidad) ?>">Gráficas Escultura y Modelado</a>
                    <a href="analisis_estadistico_individual_habilidades_musica.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>&mod=<?= urlencode($modalidad) ?>">Gráficas Música</a>
                    <a href="analisis_estadistico_individual_habilidades_danza.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>&mod=<?= urlencode($modalidad) ?>">Gráficas Danza y Expresión Corporal</a>
                    <a href="analisis_estadistico_individual_habilidades_teatro.php?nombre=<?= urlencode($nombreParticipante) ?>&id=<?= urlencode($documentoIdentidad) ?>&mod=<?= urlencode($modalidad) ?>">Gráficas Expresión Teatral</a>
                </div>
            </li>
        </ul>
    </nav>
</body>
</html>
