<?php
include 'db_config.php';
include 'index.php';
include "estilos.php";

// Obtener el nombre del participante y los datos enviados
$participant_name = isset($_POST['participant_name']) ? $_POST['participant_name'] : 'Anónimo';
$correctCount = isset($_POST['correct']) ? (int)$_POST['correct'] : 0;
$modalidad_deporte = isset($_POST['modalidad_deporte']) ? $_POST['modalidad_deporte'] : 'Sin modalidad';

// Mensaje de éxito
$message = "Gracias por participar en el test, $participant_name.";
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Resultados del Test</title>
    <link rel="stylesheet" href="style.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            margin: 20px;
        }
        h1, h2 {
            color: #333;
        }
        .result-box {
            border: 1px solid #ddd;
            border-radius: 5px;
            padding: 20px;
            margin: 20px auto;
            max-width: 500px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        .result-box h3 {
            margin: 10px 0;
        }
        .result-box p {
            margin: 5px 0;
            font-size: 16px;
        }
        .button-container {
            margin-top: 20px;
        }
        a.button {
            text-decoration: none;
            padding: 10px 20px;
            background-color: #4CAF50;
            color: white;
            border-radius: 5px;
            transition: background-color 0.3s;
        }
        a.button:hover {
            background-color: #45a049;
        }
    </style>
</head>
<body>
    <h1>Resultados del Test de Clasificación de Tarjetas</h1>
    <div class="result-box">
        <h2><?= htmlspecialchars($message) ?></h2>
        <h3>Detalles de la participación</h3>
        <p><strong>Nombre del participante:</strong> <?= htmlspecialchars($participant_name) ?></p>
        <p><strong>Clasificaciones correctas:</strong> <?= $correctCount ?></p>
        <p><strong>Modalidad de actividad física sugerida:</strong> <?= htmlspecialchars($modalidad_deporte) ?></p>
    </div>
    <div class="button-container">
        <a class="button" href="funciones_ejecutivas.php">Volver al Test</a>
    </div>
</body>
</html>
