<?php
// archivo resultados_retencion3.php
include 'db_config.php';
include 'index3.php'; 

if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("Error: No se encontró el identificador del test.");
}

$id = intval($_GET['id']);

// Consultar los resultados desde la base de datos
$query = "SELECT * FROM resultados_retencion WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows <= 0) {
    die("Error: No se encontraron resultados para este test.");
}

$registro = $result->fetch_assoc();

$participant_name = htmlspecialchars($registro['participant_name']);
$modalidad_deporte = htmlspecialchars($registro['modalidad_deporte']);
$aciertos = $registro['aciertos'];

if ($modalidad_deporte !== 'ninguna') {
    if ($aciertos < 2) {
        $recomendacion = "Se sugiere fuertemente poner mucho empeño en la realización de la actividad física con miras a mejorar estas habilidades cognitivas evaluadas en el test.";
    
    } elseif ($aciertos <= 3) {
        $recomendacion = "Continúe trabajando en la actividad física para fortalecer sus habilidades cognitivas.";
        } elseif ($aciertos >= 4) {
        $recomendacion = "¡Felicitaciones! Su desempeño demuestra un excelente trabajo en el programa de actividad física, lo que se refleja en sus habilidades cognitivas.";
    } 
}

if ($modalidad_deporte == 'ninguna') {
    if ($aciertos < 2) {
        $recomendacion = "Se sugiere fuertemente poner mucho empeño con miras a mejorar estas habilidades cognitivas evaluadas en el test.";
    
    } elseif ($aciertos <= 3) {
        $recomendacion = "Continúe trabajando para fortalecer sus habilidades cognitivas.";
        } elseif ($aciertos >= 4) {
        $recomendacion = "¡Felicitaciones! Su desempeño demuestra un excelente trabajo, lo que se refleja en sus habilidades cognitivas.";
    } 
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen de Resultados del Test</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background-color: #f4f4f4;
        }
    </style>
</head>
<body>
    <div class="test-summary-container">
    <h3 class="summary-title">Resumen del Test de Retención</h3>
    <div class="summary-box">
    <table>
        <thead>
            <tr>
                <th>Nombre del Participante</th>
                <th>Modalidad de Actividad Física</th>
                <th>Aciertos</th>
                <th>Recomendación</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php echo $participant_name; ?></td>
                <td><?php echo $modalidad_deporte; ?></td>
                <td><?php echo $aciertos; ?> de 5</td>
                <td><?php echo $recomendacion; ?></td>
            </tr>
        </tbody>
    </table>
</div>
</div>
</body>
</html>
<?php
include "styleres.css";
?>