<?php
// archivo resumen_cuestionario.php
include 'db_config.php';
include "encabezado.php" ;

$nombre_usuario = $_GET['nombre'];

$query = "SELECT * FROM cuestionarios_satisfaccion WHERE participant_name = ? ORDER BY fecha_registro DESC LIMIT 1";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $nombre_usuario);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

// Cálculo de cambios
$cambio_bienestar = $data['bienestar_post'] - $data['bienestar_pre'];
$cambio_motivacion = $data['motivacion_post'] - $data['motivacion_pre'];

// se extraen los datos para mostralos en el resumen
$modalidad = $data['modalidad_deporte'];
$recomendacion = $data['recomendacion'];
$resultado = $data["resultado"]

?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Resumen del Cuestionario de Motivación</title>
</head>
<body>
    <div class="test-summary-container">
    <h3 class="summary-title">Resumen del cuestionario de Autoevaluación</h3>
    <div class="summary-box">
    <p><strong>Nombre:</strong> <?php echo htmlspecialchars($nombre_usuario); ?></p>
    <p><strong>Modalidad de Actividad Física:</strong> <?php echo htmlspecialchars($modalidad); ?></p>
    <p><strong>Auto valoración de Bienestar:</strong> <?php echo htmlspecialchars($cambio_bienestar); ?></p>
    <p><strong>Auto valoración de Motivación:</strong> <?php echo htmlspecialchars($cambio_motivacion); ?></p>
    <p><strong>Resultado:</strong> <?php echo $resultado; ?></p>
    <p><strong>Recomendación:</strong> <?php echo $recomendacion; ?></p>
</body>
</html>
<?php
include "styleres.css";
?>