<?php
// archiv resumen_evaluacion_impacto.php
include 'db_config.php';
include 'encabezado.php';

// Verificar si se recibió un ID
if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("Error: No se proporcionó un identificador válido.");
}

$id = intval($_GET['id']);

// Consultar los datos del participante
$query = "SELECT * FROM evaluacion_impacto WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Error: No se encontraron resultados para el ID proporcionado.");
}

$registro = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen de Evaluación</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 20px;
            background-color: #f9f9f9;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            background: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        h1 {
            text-align: center;
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            border: 1px solid #ddd;
            text-align: center;
        }
        th {
            background-color: #f4f4f4;
        }
        .recomendacion {
            text-align: left;
            font-style: italic;
        }
    </style>
</head>
<body>
<div class="container">
    <h1>Resumen de Evaluación</h1>
    <table>
        <thead>
            <tr>
                <th>Nombre del Participante</th>
                <th>Modalidad de Actividad Física</th>
                <th>Puntaje Promedio</th>
                <th>Recomendación</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php echo htmlspecialchars($registro['participant_name']); ?></td>
                <td><?php echo htmlspecialchars($registro['modalidad_deporte']); ?></td>
                <td><?php echo number_format($registro['promedio'], 2); ?></td>
                <td class="recomendacion"><?php echo htmlspecialchars($registro['recomendacion']); ?></td>
            </tr>
        </tbody>
    </table>

    <h2>Detalles de Puntajes</h2>
    <table><br><br><br>
        <thead>
            <tr>
                <th>Pregunta</th>
                <th>Puntaje</th>
            </tr>
        </thead>
        <tbody>
            <?php
            for ($i = 1; $i <= 10; $i++) {
                echo "<tr>
                        <td>Pregunta $i</td>
                        <td>" . intval($registro["pregunta$i"]) . "</td>
                    </tr>";
            }
            ?>
        </tbody>
    </table>
</div>
</body>
</html>
