<?php
// archivo resumen_logros3.php
include 'db_config.php';
include 'index3.php';

// Iniciar la sesión (si aún no está iniciada)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Verificar si se ha recibido el nombre del usuario, ya sea por GET o en la sesión
if (isset($_GET['participant_name']) && !empty(trim($_GET['participant_name']))) {
    $nombreParticipante = trim($_GET['participant_name']);
    // Guardar el nombre en la sesión para uso futuro
    $_SESSION['participant_name'] = $nombreParticipante;
} elseif (isset($_SESSION['participant_name']) && !empty(trim($_SESSION['participant_name']))) {
    $nombreParticipante = trim($_SESSION['participant_name']);
} else {
    die("Error: No se especificó el nombre del usuario. Por favor, inicia sesión para continuar.");
}

// Consultar los logros del usuario en la base de datos
$query = "SELECT participant_name, modalidad_deporte, logro_academico, logro_personal 
          FROM logros 
          WHERE participant_name = ? 
          ORDER BY fecha_registro DESC 
          LIMIT 1";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $nombreParticipante);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();

// Si no se encontraron registros, mostrar un mensaje informativo
if (!$data) {
    die("<h1>Resumen de Logros</h1><p>No se encontraron logros registrados para <strong>" . htmlspecialchars($nombreParticipante) . "</strong>.</p>");
}

// Extraer los datos obtenidos, asignando un valor por defecto en caso de que algún campo sea nulo
$nombreParticipante = htmlspecialchars($data['participant_name'] ?? 'No disponible');
$modalidad = htmlspecialchars($data['modalidad_deporte'] ?? 'No disponible');
$logro_academico = htmlspecialchars($data['logro_academico'] ?? 'No disponible');
$logro_personal = htmlspecialchars($data['logro_personal'] ?? 'No disponible');
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen de Logros</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background-color: #f4f4f4;
        }
    </style>
</head>
<body>
    <div class="test-summary-container">
        <h3 class="summary-title">Resumen de Logros</h3>
        <div class="summary-box">
            <p><strong>Nombre del Usuario:</strong> <?php echo $nombreParticipante; ?></p>
            <table>
                <thead>
                    <tr>
                        <th>Modalidad Deporte</th>
                        <th>Logro Académico</th>
                        <th>Logro Personal</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo $modalidad; ?></td>
                        <td><?php echo $logro_academico; ?></td>
                        <td><?php echo $logro_personal; ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>
<?php
include "styleres.css";
?>
