<?php
//archivo resumen_resultado_danza_expresion_corporal.php
include 'db_config.php';
include 'encabezado.php';


if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("Error: No se encontró el identificador del test.");
}

$id = intval($_GET['id']);

// Consultar los resultados desde la base de datos
$query = "SELECT * FROM danza_expresion_corporal WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Error: No se encontraron resultados para este test.");
}

$registro = $result->fetch_assoc();

// Extraer la información del registro con manejo de valores nulos
$participant_name = htmlspecialchars($registro['participant_name'] ?? 'Sin nombre');
$modalidad_deporte = htmlspecialchars($registro['modalidad_deporte'] ?? 'Sin actividad');
$puntaje_coordinacion = intval($registro['puntaje_coordinacion'] ?? 0);
$puntaje_equilibrio = intval($registro['puntaje_equilibrio'] ?? 0);
$puntaje_control_corporal = intval($registro['puntaje_control_corporal'] ?? 0);
$puntaje_espontaneidad = intval($registro['puntaje_espontaneidad'] ?? 0);
$puntaje_creatividad = intval($registro['puntaje_creatividad'] ?? 0);
$recomendacion = htmlspecialchars($registro['recomendacion'] ?? 'No aplica');
?>



<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen del Test de Artes Visuales: Escultura y Modelado</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background-color: #f4f4f4;
        }
    </style>
</head>
<body>
    <div class="test-summary-container">
    <h3 class="summary-title">Resumen del Test de Artes: Danza y expresión corporal</h3>
    <div class="summary-box">
    <table>
        <thead>
            <tr>
                <th>Nombre del Participante</th>
                <th>Modalidad de Actividad Física</th>
                <th>Puntaje Coordinación</th>
                <th>Puntaje Equilibrio</th>
                <th>Puntaje Control Corporal</th>
                <th>Puntaje Espontaneidad</th>
                <th>Puntaje Creatividad</th>
                <th>Resultado y Recomendación</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php echo $participant_name; ?></td>
                <td><?php echo $modalidad_deporte; ?></td>
                <td><?php echo $puntaje_coordinacion; ?></td>
                <td><?php echo $puntaje_equilibrio; ?></td>
                <td><?php echo $puntaje_control_corporal; ?></td>
                <td><?php echo $puntaje_espontaneidad; ?></td>
                <td><?php echo $puntaje_creatividad; ?></td>
                <td><?php echo $recomendacion; ?></td>
            </tr>
        </tbody>
    </table>
    </div>
</div>
</body>
</html>
<?php
include "styleres.css";
?>