<?php
//archivo resumen_resultado_escultura_modelado.php
include 'db_config.php';
include 'encabezado.php';


if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("Error: No se encontró el identificador del test.");
}

$id = intval($_GET['id']);

// Consultar los resultados desde la base de datos
$query = "SELECT * FROM escultura_modelado WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Error: No se encontraron resultados para este test.");
}

$registro = $result->fetch_assoc();

// Extraer la información del registro con manejo de valores nulos
$participant_name = htmlspecialchars($registro['participant_name'] ?? 'Sin nombre');
$modalidad_deporte = htmlspecialchars($registro['modalidad_deporte'] ?? 'Sin actividad');
$puntaje_destreza = intval($registro['puntaje_destreza'] ?? 0);
$puntaje_fuerza = intval($registro['puntaje_fuerza'] ?? 0);
$puntaje_coordinacion = intval($registro['puntaje_coordinacion'] ?? 0);
$recomendacion = htmlspecialchars($registro['recomendacion'] ?? 'No aplica');
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen del Test de Artes Visuales: Escultura y Modelado</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background-color: #f4f4f4;
        }
    </style>
</head>
<body>
    <div class="test-summary-container">
    <h3 class="summary-title">Resumen del Test de Artes Visuales: Escultura y Modelado</h3>
    <div class="summary-box">
    <table>
        <thead>
            <tr>
                <th>Nombre del Participante</th>
                <th>Modalidad de Actividad Física</th>
                <th>Puntaje Destreza</th>
                <th>Puntaje Fuerza</th>
                <th>Puntaje Coordinación</th>
                <th>Resultado y Recomendación</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php echo $participant_name; ?></td>
                <td><?php echo $modalidad_deporte; ?></td>
                <td><?php echo $puntaje_destreza; ?></td>
                <td><?php echo $puntaje_fuerza; ?></td>
                <td><?php echo $puntaje_coordinacion; ?></td>
                <td><?php echo $recomendacion; ?></td>
            </tr>
        </tbody>
    </table>
</div>
</div>
</body>
</html>
<?php
include "styleres.css";
?>