<?php
//archivo resumen_resultado_expresion_teatral3.php
include 'db_config.php';
include 'index3.php';


if (!isset($_GET['id']) || empty($_GET['id'])) {
    die("Error: No se encontró el identificador del test.");
}

$id = intval($_GET['id']);

// Consultar los resultados desde la base de datos
$query = "SELECT * FROM expresion_teatral WHERE id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Error: No se encontraron resultados para este test.");
}

$registro = $result->fetch_assoc();

// Extraer la información del registro con manejo de valores nulos
$participant_name = htmlspecialchars($registro['participant_name'] ?? 'Sin nombre');
$modalidad_deporte = htmlspecialchars($registro['modalidad_deporte'] ?? 'Sin actividad');
$puntaje_expresion = intval($registro['puntaje_expresion'] ?? 0);
$puntaje_proyectar_voz = intval($registro['puntaje_proyectar_voz'] ?? 0);
$puntaje_control_corporal = intval($registro['puntaje_control_corporal'] ?? 0);
$puntaje_modular_tonos = intval($registro['puntaje_modular_tonos'] ?? 0);
$puntaje_articulacion = intval($registro['puntaje_articulacion'] ?? 0);
$recomendacion = htmlspecialchars($registro['recomendacion'] ?? 'No aplica');
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resumen del Test de Artes Teatrales</title>
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th, td {
            padding: 10px;
            text-align: left;
            border: 1px solid #ddd;
        }
        th {
            background-color: #f4f4f4;
        }
    </style>
</head>
<body>

    <div class="test-summary-container">
    <h3 class="summary-title">Resumen del Test de Artes Teatrales</h3>
    <div class="summary-box">
    <table>
        <thead>
            <tr>
                <th>Nombre del Participante</th>
                <th>Modalidad de Actividad Física</th>
                <th>Puntaje Expresión</th>
                <th>Puntaje Proyección de la Voz</th>
                <th>Puntaje Control Corporal</th>
                <th>Puntaje Modulación Tonos de Voz</th>
                <th>Puntaje Articulación de las Palabras</th>
                <th>Resultado y Recomendación</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td><?php echo $participant_name; ?></td>
                <td><?php echo $modalidad_deporte; ?></td>
                <td><?php echo $puntaje_expresion; ?></td>
                <td><?php echo $puntaje_proyectar_voz; ?></td>
                <td><?php echo $puntaje_control_corporal; ?></td>
                <td><?php echo $puntaje_modular_tonos; ?></td>
                <td><?php echo $puntaje_articulacion; ?></td>
                <td><?php echo $recomendacion; ?></td>
            </tr>
        </tbody>
    </table>
</div>
</div>
</body>
</html>
<?php
include "styleres.css";
?>