<?php
// archivo retencion.php
include 'db_config.php'; // Configuración de la base de datos
include 'encabezado.php';

$nombreParticipante = isset($_GET['nombre']) ? $_GET['nombre'] : '';
$documentoIdentidad = isset($_GET['id']) ? $_GET['id'] : ''; // ID del participante

if (!$conn) {
    die("Error de conexión a la base de datos: " . $conn->connect_error);
}

// Seleccionar una lectura aleatoria
$query = "SELECT * FROM lecturas_retencion ORDER BY RAND() LIMIT 1";
$result = $conn->query($query);

if (!$result || $result->num_rows <= 0) {
    die("No se encontraron lecturas en la base de datos.");
}

$lectura = $result->fetch_assoc();
$titulo = $lectura['titulo'];
$contenido = $lectura['contenido'];
$preguntas = [
    ['pregunta' => $lectura['pregunta1'], 'respuesta' => $lectura['respuesta1_correcta'], 'distractor1' => $lectura['respuesta1_distractor1'], 'distractor2' => $lectura['respuesta1_distractor2'], 'distractor3' => $lectura['respuesta1_distractor3']],
    ['pregunta' => $lectura['pregunta2'], 'respuesta' => $lectura['respuesta2_correcta'], 'distractor1' => $lectura['respuesta2_distractor1'], 'distractor2' => $lectura['respuesta2_distractor2'], 'distractor3' => $lectura['respuesta2_distractor3']],
    ['pregunta' => $lectura['pregunta3'], 'respuesta' => $lectura['respuesta3_correcta'], 'distractor1' => $lectura['respuesta3_distractor1'], 'distractor2' => $lectura['respuesta3_distractor2'], 'distractor3' => $lectura['respuesta3_distractor3']],
    ['pregunta' => $lectura['pregunta4'], 'respuesta' => $lectura['respuesta4_correcta'], 'distractor1' => $lectura['respuesta4_distractor1'], 'distractor2' => $lectura['respuesta4_distractor2'], 'distractor3' => $lectura['respuesta4_distractor3']],
    ['pregunta' => $lectura['pregunta5'], 'respuesta' => $lectura['respuesta5_correcta'], 'distractor1' => $lectura['respuesta5_distractor1'], 'distractor2' => $lectura['respuesta5_distractor2'], 'distractor3' => $lectura['respuesta5_distractor3']]
  
];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Evaluación de Retención</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <form action="save_results_retencion.php" method="POST">
    <!-- Input para el nombre del participante -->
    <label for="participant_name">Nombre del Participante:</label>
    <input type="text" id="participant_name" name="participant_name" value="<?= htmlspecialchars($nombreParticipante) ?>" required>
    <label for="participant_id">Número de Documento de Identidad:</label>
        <input type="text" id="participant_id" name="participant_id" value="<?= htmlspecialchars($documentoIdentidad) ?>" required>

    <!-- Selección de modalidad de deporte -->
    <label for="modalidad_deporte">Modalidad de Actividad Física:</label>
    <select id="modalidad_deporte" name="modalidad_deporte" required>
        <option value="ninguna">Ninguna</option>
        <option value="baja intensidad y equilibrio">Baja intensidad y equilibrio</option>
        <option value="resistencia moderada">Resistencia moderada</option>
        <option value="aerobicos adaptados">Aeróbicos adaptados</option>
    </select>

    <!-- Título y contenido de la lectura -->
<h1><?php echo htmlspecialchars($titulo); ?></h1>
<p><?php echo nl2br(htmlspecialchars($contenido)); ?></p>

<?php foreach ($preguntas as $index => $pregunta): ?>
    <label for="respuesta<?php echo $index; ?>"><?php echo htmlspecialchars($pregunta['pregunta']); ?></label>
    
    <?php
    // Creamos un array con todas las opciones de respuesta
    $opciones = [
        $pregunta['respuesta'], // Respuesta correcta
        $pregunta['distractor1'],
        $pregunta['distractor2'],
        $pregunta['distractor3']
    ];

    // Mezclamos el array para que las respuestas aparezcan en orden aleatorio
    shuffle($opciones);
    ?>

    <select id="respuesta<?php echo $index; ?>" name="respuesta<?php echo $index; ?>" required>
        <option value="">Seleccione una respuesta</option>
        <?php foreach ($opciones as $opcion): ?>
            <option value="<?php echo htmlspecialchars($opcion); ?>"><?php echo htmlspecialchars($opcion); ?></option>
        <?php endforeach; ?>
    </select>

    <input type="hidden" name="correcta<?php echo $index; ?>" value="<?php echo htmlspecialchars($pregunta['respuesta']); ?>">
    <br>
<?php endforeach; ?>

<button type="submit">Enviar Respuestas</button>

</form>

</body>
</html>
