<?php
//archivo save_bienestar_motivacion3.php ;
include 'db_config.php';

// Habilitar reporte de errores
/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Establecer cabeceras para JSON
header('Content-Type: application/json');

// Leer datos de la solicitud
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Verificar si los datos fueron recibidos
if (!$data) {
    echo json_encode(['status' => 'error', 'message' => 'No se recibieron datos válidos.']);
    exit;
}*/
$nombre = $_POST['participant_name'] ?? 'Sin nombre';
$participant_id = $_POST['participant_id'] ?? 'Sin nombre';
$modalidad = $_POST['modalidad_deporte'] ?? 'ninguna';
$bienestar_pre = intval($_POST['bienestar_pre']);
$bienestar_post = intval($_POST['bienestar_post']);
$motivacion_pre = intval($_POST['motivacion_pre']);
$motivacion_post = intval($_POST['motivacion_post']);


// Generar resultado independiente de la modalidad
$promedio_pre = ($bienestar_pre + $bienestar_post + $motivacion_pre + $motivacion_post) / 2;
if ($promedio_pre < 4) {
    $resultado = "La autopercepción de bienestar y motivación de $nombre no es buena. Debe ser consciente de que está bien sentirse así a veces. Los profesionales de Proyecto 21 estamos para acompañarle y ayudarle a superar sus dificultades. Todo mejorará paso a paso. 💙 Debe considerar ajustar su rutina de actividad física para mejorar su bienestar.";
} elseif ($promedio_pre < 8) {
    $resultado = "La autopercepción de bienestar y motivación de $nombre es buena. Le recordamos que va por buen camino. Si hoy es un día regular, está bien. Debe seguir adelante, hacer actividades que le produzcan placer y recordar que cada pequeño paso cuenta. ¡Tú puedes! 😊";
} else {
    $resultado = "La autopercepción de bienestar y motivación de $nombre es muy buena. ¡Qué alegría nos da saber que $nombre se siente así! Debe seguir en esa tónica disfrutando de la vida, aprovechando su energía y compartiendo su alegría con los demás. ¡Sigue así! 😊🎉 Sigue participando en actividades físicas.";
}

// Generar recomendación independiente de la modalidad
$promedio_post = ($bienestar_pre + $bienestar_post + $motivacion_pre + $motivacion_post) / 2;
if ($promedio_post < 4) {
    $recomendacion = "Está bien sentirse así a veces. Respira profundo, descansa un poco y habla con alguien que te quiera. Todo mejora poco a poco. 💙 Considera ajustar tu rutina de actividad física para mejorar tu bienestar.";
} elseif ($promedio_post < 8) {
    $recomendacion = "Vas por buen camino. Si hoy es un día regular, está bien. Sigue adelante, haz algo que te guste y recuerda que cada pequeño paso cuenta. ¡Tú puedes! 😊";
} else {
    $recomendacion = "¡Qué alegría saber que te sientes así! Sigue disfrutando tu día, aprovecha tu energía y comparte tu alegría con los demás. ¡Sigue así! 😊🎉 Sigue participando en actividades físicas.";
}

$query = "INSERT INTO cuestionarios_satisfaccion (participant_name, participant_id, modalidad_deporte, bienestar_pre, bienestar_post, motivacion_pre, motivacion_post, resultado, recomendacion) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($query);
$stmt->bind_param("sssiiiiss", $nombre, $participant_id, $modalidad, $bienestar_pre, $bienestar_post, $motivacion_pre, $motivacion_post, $resultado, $recomendacion);
$stmt->execute();

header("Location: resumen_cuestionario3.php?nombre=$nombre");
?>