<?php
// Archivo save_evaluacion.php
include 'db_config.php';

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $nombreParticipante = $_POST['participant_name'];
    $documentoIdentidad = $_POST['participant_id'];
    $modalidadDeporte = $_POST['modalidad_deporte'];
    $respuestas = [];
    $totalPreguntas = 10; // Número de preguntas en el formulario

    // Capturar las respuestas del formulario
    for ($i = 1; $i <= $totalPreguntas; $i++) {
        $respuestas[] = (int)$_POST["pregunta$i"];
    }

    $promedioActual = array_sum($respuestas) / $totalPreguntas;
    $recomendacion = '';

    // Recuperar las dos últimas evaluaciones (si existen)
    $queryUltimasEvaluaciones = "
        SELECT promedio 
        FROM evaluacion_impacto 
        WHERE participant_name = ? 
        ORDER BY fecha_registro DESC 
        LIMIT 2";
    $stmt = $conn->prepare($queryUltimasEvaluaciones);
    $stmt->bind_param("s", $nombreParticipante);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $promediosPrevios = [];
    while ($row = $result->fetch_assoc()) {
        $promediosPrevios[] = $row['promedio'];
    }
    $stmt->close();

    // Generar recomendación basada en la comparación
    if (count($promediosPrevios) > 0) {
        $ultimoPromedio = $promediosPrevios[0];
        if ($promedioActual > $ultimoPromedio) {
            $recomendacion = "¡Haz mejorado con respecto a la evaluación anterior! Sigue manteniendo este esfuerzo.";
        } elseif ($promedioActual < $ultimoPromedio) {
            $recomendacion = "Se observa una disminución en el progreso. Considera reforzar las estrategias de aprendizaje.";
        } else {
            $recomendacion = "Tu desempeño se mantiene igual. Es momento de enfocarte en áreas específicas para mejorar.";
        }
    } else {
        $recomendacion = "Esta es tu primera evaluación. ¡Buen inicio!";
    }

    // Añadir recomendaciones específicas de actividad física
    switch ($modalidadDeporte) {
        case 'baja intensidad y equilibrio':
            $recomendacion .= " Se recomienda mantener ejercicios de equilibrio y fortalecimiento básico.";
            break;
        case 'resistencia moderada':
            $recomendacion .= " Continúa con actividades de resistencia moderada para mejorar tu bienestar físico.";
            break;
        case 'aerobicos adaptados':
            $recomendacion .= " Sigue practicando aeróbicos adaptados para fortalecer tu capacidad cardiovascular.";
            break;
        case 'ninguna':
            $recomendacion .= " Considera incorporar actividad física regular para mejorar tu salud y desempeño.";
            break;
    }

    // Guardar la evaluación en la base de datos
    $queryInsert = "
        INSERT INTO evaluacion_impacto (
            participant_name,
            participant_id, 
            modalidad_deporte, 
            pregunta1, pregunta2, pregunta3, pregunta4, pregunta5, 
            pregunta6, pregunta7, pregunta8, pregunta9, pregunta10, 
            promedio, recomendacion, fecha_registro
        ) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())";

    $stmt = $conn->prepare($queryInsert);
    $stmt->bind_param(
        "sssiiiiiiiiiiis",
        $nombreParticipante,
        $documentoIdentidad,
        $modalidadDeporte,
        $respuestas[0],
        $respuestas[1],
        $respuestas[2],
        $respuestas[3],
        $respuestas[4],
        $respuestas[5],
        $respuestas[6],
        $respuestas[7],
        $respuestas[8],
        $respuestas[9],
        $promedioActual,
        $recomendacion
    );

    if ($stmt->execute()) {
        echo "Evaluación guardada exitosamente.<br>";
        echo "Promedio actual: " . number_format($promedioActual, 2) . "<br>";
        echo "Recomendación: " . htmlspecialchars($recomendacion);
    } else {
        echo "Error al guardar la evaluación: " . $stmt->error;
    }

    if ($stmt->execute()) {
    $insert_id = $stmt->insert_id;
    header("Location: resumen_evaluacion_impacto.php?id=$insert_id");
} else {
    die("Error al guardar los datos: " . $stmt->error);
}
    $stmt->close();
    $conn->close();
}
?>
