<?php
// save_result_comprension_lectora3.php

// Activar la visualización de errores en desarrollo (quitar en producción)
error_reporting(E_ALL);
ini_set('display_errors', 1);
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

// Incluir archivos necesarios
include 'db_config.php'; 
include 'index3.php';

// Asegurarse de que la conexión use el charset adecuado
$conn->set_charset("utf8mb4");

// Forzar autocommit (por defecto ya está activado)
$conn->autocommit(true);

// Usar el nombre de la tabla sin tilde
$tableName = 'lectura_comprensión';

try {
    // Recibir datos del formulario
    $participant_name  = trim(htmlspecialchars($_POST['participant_name'] ?? ''));
    $participant_id    = trim(htmlspecialchars($_POST['participant_id'] ?? ''));
    $modalidad_deporte = trim(htmlspecialchars($_POST['modalidad_deporte'] ?? ''));
    $answers           = $_POST['answers'] ?? [];
    $correct_answers   = $_POST['correct_answers'] ?? [];

    // Validación de datos obligatorios
    if (empty($participant_name) || empty($participant_id)) {
        echo json_encode(["error" => "El nombre y el ID del participante son obligatorios."]);
        exit;
    }
    if (!is_array($answers) || empty($answers)) {
        echo json_encode(["error" => "Debe responder todas las preguntas."]);
        exit;
    }

    // Calcular puntaje
    $score = 0;
    foreach ($correct_answers as $question => $correct_answer) {
        if (isset($answers[$question]) && $answers[$question] === $correct_answer) {
            $score++;
        }
    }
    // Total de preguntas
    $total_questions = count($correct_answers);
    // Calcular porcentaje
    $percentage = $total_questions > 0 ? ($score / $total_questions) * 100 : 0;

    // Generar apreciaciones y recomendaciones
    if ($percentage >= 75) {
        $appreciation   = "Excelente comprensión lectora.";
        $recommendation = "Continúa practicando con textos más avanzados.";
    } elseif ($percentage >= 50) {
        $appreciation   = "Buena comprensión lectora.";
        $recommendation = "Trabaja en analizar los textos con mayor profundidad.";
    } else {
        $appreciation   = "Necesita mejorar su comprensión lectora.";
        $recommendation = "Lee con más frecuencia y busca apoyo para entender mejor los textos.";
    }
    // Agregar recomendaciones basadas en la modalidad de deporte
    if (!empty($modalidad_deporte)) {
        if ($score >= ($total_questions * 0.6)) {
            $recommendation .= " Además, puedes integrar ejercicios específicos relacionados con tu modalidad de deporte.";
        } else {
            $recommendation .= " Considera integrar más ejercicios cognitivos y físicos, incluyendo actividades en tu modalidad de deporte.";
        }
    }

    // Verificar si el participante ya tiene registros previos
    $sql = "SELECT score FROM $tableName WHERE participant_id = ?";
    $stmt = $conn->prepare($sql);
    if (!$stmt) {
        throw new Exception("Error en la preparación de SELECT: " . $conn->error);
    }
    $stmt->bind_param('s', $participant_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Registro previo: actualizar
        $row = $result->fetch_assoc();
        $previousScore = $row['score'];
        $progress = "El resultado obtenido fue $score de $total_questions. ";
        if ($score > $previousScore) {
            $progress .= "Has mejorado en comparación con tu test anterior.";
        } elseif ($score == $previousScore) {
            $progress .= "Tu desempeño se mantiene estable.";
        } else {
            $progress .= "Tu puntaje es inferior al test anterior, sigue practicando.";
        }
        $stmt->close();

       /* $sql_update = "UPDATE $tableName SET score = ?, comprension = ?, recomendaciones = ?, progreso = ? WHERE participant_id = ?";
        $stmt_update = $conn->prepare($sql_update);
        if (!$stmt_update) {
            throw new Exception("Error en la preparación de UPDATE: " . $conn->error);
        }
        $stmt_update->bind_param('issss', $score, $appreciation, $recommendation, $progress, $participant_id);
        $stmt_update->execute();
        if ($stmt_update->affected_rows < 1) {
            error_log("UPDATE: No se actualizó ningún registro. Datos enviados: score=$score, comprension=$appreciation, recomendaciones=$recommendation, progreso=$progress, participant_id=$participant_id");
        }
        $stmt_update->close();
    } else {
        // No existe registro previo: insertar
        $stmt->close();*/
        $progress = "El resultado obtenido fue $score de $total_questions.";
        $sql_insert = "INSERT INTO $tableName (participant_name, participant_id, modalidad_deporte, score, comprension, recomendaciones, progreso) VALUES (?, ?, ?, ?, ?, ?, ?)";
        $stmt_insert = $conn->prepare($sql_insert);
        if (!$stmt_insert) {
            throw new Exception("Error en la preparación de INSERT: " . $conn->error);
        }
        $stmt_insert->bind_param('sssisss', $participant_name, $participant_id, $modalidad_deporte, $score, $appreciation, $recommendation, $progress);
        $stmt_insert->execute();
        if ($stmt_insert->affected_rows < 1) {
            error_log("INSERT: No se insertó ningún registro. Datos enviados: participant_name=$participant_name, participant_id=$participant_id, modalidad_deporte=$modalidad_deporte, score=$score, comprension=$appreciation, recomendaciones=$recommendation, progreso=$progress");
        }
        $stmt_insert->close();
    }
    $conn->close();
} catch (Exception $e) {
    // Mostrar error detallado
    echo "<pre>Error: " . $e->getMessage() . "\n" . $e->getTraceAsString() . "</pre>";
    exit;
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Resumen del Test de Comprensión Lectora</title>
    <link rel="stylesheet" href="styleres.css">
</head>
<body>
<div class="test-summary-container">
    <h3 class="summary-title">Resumen del Test de Comprensión Lectora</h3>
    <div class="summary-box">
        <p><strong>Nombre del participante:</strong> <?= htmlspecialchars($participant_name) ?></p>
        <p><strong>Modalidad de actividad física:</strong> <?= htmlspecialchars($modalidad_deporte) ?></p>
        <p><strong>Puntaje obtenido:</strong> <?= $score ?> aciertos de <?= $total_questions ?></p>
        <p><strong>Comprensión:</strong> <?= htmlspecialchars($appreciation) ?></p>
        <p><strong>Recomendaciones:</strong> <?= htmlspecialchars($recommendation) ?></p>
        <p><strong>Progreso:</strong> <?= htmlspecialchars($progress) ?></p>
    </div>
</div>
</body>
</html>
