<?php
// archivo save_result_danza_expresion_corporal3.php
include 'db_config.php';


$nombre = $_POST['participant_name'] ?? 'Sin nombre';
$documentoIdentidad = $_POST['participant_id'] ?? 'Sin id';
$modalidad = $_POST['modalidad_deporte'] ?? 'ninguna';
$puntaje_coordinacion = intval($_POST['puntaje_coordinacion'] ?? 0);
$puntaje_equilibrio = intval($_POST['puntaje_equilibrio'] ?? 0);
$puntaje_control_corporal = intval($_POST['puntaje_control_corporal'] ?? 0);
$puntaje_espontaneidad = intval($_POST['puntaje_espontaneidad'] ?? 0);
$puntaje_creatividad = intval($_POST['puntaje_creatividad'] ?? 0);

// Generar recomendación si aplica
$recomendacion = "";
if ($modalidad !== 'ninguna') {
    $promedio = ($puntaje_coordinacion + $puntaje_equilibrio + $puntaje_control_corporal +  $puntaje_espontaneidad + $puntaje_creatividad ) / 5;
    if ($promedio < 5) {
        $recomendacion = "Mejora necesaria, Se sugiere fuertemente poner mucho empeño en la realización de la actividad física con miras a mejorar estas habilidades cognitivas evaluadas en el test.";
    } elseif ($promedio < 6) {
        $recomendacion = "Continúe trabajando en la actividad física para fortalecer sus habilidades artisticas.";
    } else {
        $recomendacion = "¡Felicitaciones! Su desempeño demuestra un excelente trabajo en el programa de actividad física, lo que se refleja en sus habilidades artísticas sobresalientes.";
    }
} 

if ($modalidad == 'ninguna') {
    $promedio = ($puntaje_coordinacion + $puntaje_equilibrio + $puntaje_control_corporal +  $puntaje_espontaneidad + $puntaje_creatividad ) / 5;
    if ($promedio < 5) {
        $recomendacion = "Mejora necesaria, Se sugiere fuertemente poner mucho empeño con miras a mejorar estas habilidades cognitivas evaluadas en el test.";
    } elseif ($promedio < 6) {
        $recomendacion = "Continúe trabajando para fortalecer sus habilidades artisticas.";
    } else {
        $recomendacion = "¡Felicitaciones! Su desempeño demuestra un excelente trabajo, lo que se refleja en sus habilidades artísticas sobresalientes.";
    }
} 

// Guardar resultados en la base de datos
$query_usuario = "INSERT INTO danza_expresion_corporal (participant_name, participant_id, modalidad_deporte, puntaje_coordinacion, puntaje_equilibrio, puntaje_control_corporal, puntaje_espontaneidad, puntaje_creatividad, recomendacion) 
                  VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt_usuario = $conn->prepare($query_usuario);
$stmt_usuario->bind_param("sssiiiiis", $nombre, $documentoIdentidad, $modalidad, $puntaje_coordinacion, $puntaje_equilibrio, $puntaje_control_corporal, $puntaje_espontaneidad, $puntaje_creatividad, $recomendacion);
$stmt_usuario->execute();

if ($stmt_usuario->affected_rows > 0) {
    $usuario_id = $stmt_usuario->insert_id;
    header("Location: resumen_resultado_danza_expresion_corporal3.php?id=$usuario_id");
    exit();
} else {
    die("Error al guardar los resultados: " . $conn->error);
}
?>
