<?php
// archivo save_result_dibujo_pintura.php
include 'db_config.php';


$nombre = $_POST['participant_name'] ?? 'Sin nombre';
$documentoIdentidad = $_POST['participant_id'] ?? 'Sin id';
$modalidad = $_POST['modalidad_deporte'] ?? 'ninguna';
$puntaje_precision = intval($_POST['puntaje_precision'] ?? 0);
$puntaje_colores = intval($_POST['puntaje_colores'] ?? 0);
$puntaje_organizacion = intval($_POST['puntaje_organizacion'] ?? 0);

// Generar recomendación si aplica
$recomendacion = "";
if ($modalidad !== 'ninguna') {
    $promedio = ($puntaje_precision + $puntaje_colores + $puntaje_organizacion) / 3;
    if ($promedio < 5) {
        $recomendacion = "Mejora necesaria, Se sugiere fuertemente poner mucho empeño en la realización de la actividad física con miras a mejorar estas habilidades cognitivas evaluadas en el test, entre otras su motricidad fina.";
    } elseif ($promedio < 6) {
        $recomendacion = "Continúe trabajando en la actividad física para fortalecer sus habilidades artisticas.";
    } else {
        $recomendacion = "¡Felicitaciones! Su desempeño demuestra un excelente trabajo en el programa de actividad física, lo que se refleja en sus habilidades artísticas sobresalientes.";
    }
} 
if ($modalidad == 'ninguna') {
    $promedio = ($puntaje_precision + $puntaje_colores + $puntaje_organizacion) / 3;
    if ($promedio < 5) {
        $recomendacion = "Mejora necesaria, Se sugiere fuertemente poner mucho empeño con miras a mejorar su motricidad fina.";
    } elseif ($promedio < 6) {
        $recomendacion = "Continúe trabajando para fortalecer habilidades artisticas.";
    } else {
        $recomendacion = "¡Excelente trabajo, felicitaciones! Su desempeño demuestra un excelente trabajo, lo que se refleja en sus habilidades artísticas sobresalientes.";
    }
} 



// Guardar resultados en la base de datos
$query_usuario = "INSERT INTO dibujo_pintura (participant_name, participant_id, modalidad_deporte, puntaje_precision, puntaje_colores, puntaje_organizacion,  recomendacion) /*resultado,*/
                  VALUES (?, ?, ?, ?, ?, ?, ?)";//, ?
$stmt_usuario = $conn->prepare($query_usuario);
$stmt_usuario->bind_param("sssiiis", $nombre, $documentoIdentidad, $modalidad, $puntaje_precision, $puntaje_colores, $puntaje_organizacion,  $recomendacion); //$resultado,
$stmt_usuario->execute();

if ($stmt_usuario->affected_rows > 0) {
    $usuario_id = $stmt_usuario->insert_id;
    header("Location: resumen_resultado_dibujo_pintura.php?id=$usuario_id");
    exit();
} else {
    die("Error al guardar los resultados: " . $conn->error);
}
?>
