<?php
// archivo save_result.php

// Incluir archivos necesarios
include 'db_config.php';
include 'encabezado.php';

// Función para evaluar el texto
function evaluarTexto($texto) {
    $texto = strtolower(trim($texto));
    $oraciones = preg_split('/(?<=[.?!])\s+/', $texto);
    $totalPuntaje = 0;
    $apreciacion = '';
    $totalOraciones = count($oraciones);
    
    foreach ($oraciones as $oracion) {
        $oracion = trim($oracion);
        $sujeto = false;
        $verbo = false;
        $complemento = false;

        // Buscar sujeto (simplificación)
        if (preg_match('/\b(yo|él|ella|nosotros|nosotras|ellos|ellas|paseo|animal|dia|parque|semana|playa|hoy|familia|juguete|escuela|mis|amigo|amigos|amiga|amigas|lluvia|mi|su|nuestro|nuestras|suya|actividad|aquella|esa|ese|me|ir|tengo|tenemos|tuvimos|lunes|martes|miercoles|jueves|viernes|sabado|domingo)\b/', $oracion)) {
            $sujeto = true;
        }

        // Buscar verbo (simplificación)
        if (preg_match('/\b(es|está|tiene|fue|ser|hice|hiciste|hizo|hicimos|hicieron|comer|como|cómo|comes|comi|comimos|comieron|beber|bebo|bebe|bebemos|bebimos|bebi|sentir|senti|siento|sentimos|bajar|baje|bajamos|bajaron|subir|subi|subimos|subieron|vivir|vivi|vivimos|vivieron|viviamos|comprar|compre|compramos|compraron|comprabamos|mirar|mire|miramos|mirabamos|miraron|visitar|visite|visitamos|visitabamos|visitaron|cantar|cante|cantamos|cantaron|cantabamos|bailar|baile|bailabamos|bailaron|bailaban|hacia|comiamos|brincamos|brinque|estuvimos|estuve|estuvo|estva|era|eran|fui|fuimos|fueron|soy|es|eres|somos|estoy|esta|estamos|estan)\b/', $oracion)) {
            $verbo = true;
        }

        // Buscar complemento (simplificación)
        if (preg_match('/\b(a|con|por|para|de|favorito|favorita|sobre|tras|contra|alto|bajo|triste|alegre|pereza|en|un|encuentra|cerca|lejos|lo|la|el|mucho|poco|no|si|esa|aquella|asi|hacia|entre|porque|que|una|uno|nunca|siempre|jamas|tado|toda|muy|bonita|bonito|gusta|comida|gusta)\b/', $oracion)) {
            $complemento = true;
        }

        // Asignar puntaje según los elementos presentes
        $elementos_presentes = 0;
        if ($sujeto) $elementos_presentes++;
        if ($verbo) $elementos_presentes++;
        if ($complemento) $elementos_presentes++;

        switch ($elementos_presentes) {
            case 3:
                $puntaje = 5;
                break;
            case 2:
                $puntaje = 3;
                break;
            case 1:
                $puntaje = 1;
                break;
            default:
                $puntaje = 0;
                break;
        }

        $totalPuntaje += $puntaje;
    }

    // Determinar la apreciación.
    if ($totalPuntaje >= ($totalOraciones * 4)) {
        $apreciacion = "Sus capacidades de redacción son excelentes. En el text realizado se apreció una estructura clara y coherente.";
    } elseif ($totalPuntaje >= ($totalOraciones * 3)) {
        $apreciacion = "Sus capacidades de redacción son buenas, pero podría mejorar la estructura en algunas oraciones.";
    } elseif ($totalPuntaje >= ($totalOraciones * 2)) {
        $apreciacion = "Sus capacidades de redacción tienen algunas deficiencias en la estructura gramatical. Se recomienda practicar.";
    } else {
        $apreciacion = "En cuanto a sus capacidades de redacción se requiere mejorar la estructura de las oraciones. Debe intentar enfocarse más en la coherencia y la claridad.";
    }

    return ['puntaje' => $totalPuntaje, 'apreciacion' => $apreciacion];
}

// Validar datos del formulario
$textoUsuario = $_POST['writing_input'] ?? '';
$participantId = $_POST['participant_id'] ?? null;
$participantName = $_POST['participant_name'] ?? null;
$modalidadDeporte = $_POST['modalidad_deporte'] ?? null;

if (!$textoUsuario || !$participantId || !$participantName || !$modalidadDeporte) {
    echo json_encode(['success' => false, 'error' => 'Datos incompletos.']);
    exit;
}

// Evaluar el texto del usuario
$resultadoEvaluacion = evaluarTexto($textoUsuario);
$puntaje = $resultadoEvaluacion['puntaje'];
$descripcion = $resultadoEvaluacion['apreciacion'];

$queryCheck = "SELECT * FROM escritura WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1";
    $stmtCheck = $conn->prepare($queryCheck);
    $stmtCheck->bind_param("s", $documentoIdentidad);
    $stmtCheck->execute();
    $resultCheck = $stmtCheck->get_result();
    $isFollowUp = $resultCheck->num_rows > 0;

    $description = '';
    $recommendation = '';
    if ($isFollowUp) {
        // Comparación con el test anterior
        $lastEntry = $resultCheck->fetch_assoc();
        if ($puntaje > $lastEntry['aciertos']) {
            $description = "Comparativamente con el test anterior de escritura, hubo una mejoría.";
        } elseif ($puntaje < $lastEntry['aciertos']) {
            $description = "Comparativamente con el test anterior de escritura, hubo una disminución en el puntaje.";
        } else {
            $description = "Comparativamente con el test anterior de escritura, los resultados permanecieron iguales.";
        }
    } else {
        $description = "El resultado obtenido en el test inicial de escritura fue $puntaje aciertos.";
    }



// Generamos la Apreciación general basada en los aciertos
    $recommendations = $puntaje >= 4 ? "Sus capacidades de redacción son excelentes. ¡Felicitaciones! Su desempeño demuestra un excelente trabajo, lo que se refleja en sus habilidades cognitivas." : ($puntaje  >= 3 ? "Redacción adecuada, Continúe trabajando para fortalecer sus habilidades cognitivas." : "Mejora necesaria, Se sugiere fuertemente poner mucho empeño con miras a mejorar estas habilidades cognitivas evaluadas en el test.");


// Guardar en la base de datos
try {
    $queryInsert = "INSERT INTO escritura (participant_name, participant_id, modalidad_deporte, score, resultado, recomendaciones) 
                VALUES (?, ?, ?, ?, ?, ?)";
    $stmtInsert = $conn->prepare($queryInsert);
    $stmtInsert->bind_param("sssiss", $participantName, $participantId, $modalidadDeporte, $puntaje, $resultadoEvaluacion['apreciacion'], $recommendations);

    if ($stmtInsert->execute()) {
        echo json_encode([]); //'' => true, '' => 'Resultados guardados exitosamente.'
    } else {
        echo json_encode(['success' => false, 'error' => 'Error al guardar los resultados.']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => 'Error al guardar los resultados: ' . $e->getMessage()]);
}
?>


<!-- Resumen del test para el usuario -->
<div class="test-summary-container">
    <h3 class="summary-title">Resumen del Test de escritura</h3>
    <div class="summary-box">
        <p><strong>Nombre del participante:</strong> <?= htmlspecialchars($participantName) ?></p>
        <p><strong>Modalidad de actividad física:</strong> <?= htmlspecialchars($modalidadDeporte) ?></p>
        <p><strong>Puntaje obtenido:</strong> <?= $puntaje ?> </p>
        <p><strong>Resultado del test:</strong> <?= htmlspecialchars($descripcion) ?> </p>
        <p><?= htmlspecialchars($recommendation) ?></p>
        <p><strong>Apreciación general:</strong> <?= htmlspecialchars($recommendations) ?></p>
    </div>
</div>
<?php   
include "styleres.css";
?>