<?php
// Archivo: save_results_atencion3.php
include 'db_config.php';
include 'index3.php';

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

if (session_status() === PHP_SESSION_NONE) {
    session_start();
} 

// Se asume que el formulario se envía mediante POST
if ($_SERVER["REQUEST_METHOD"] === "POST") {

    // Obtener y limpiar los valores enviados por POST
    $participantName = isset($_POST['participant_name']) ? trim($_POST['participant_name']) : null;
    $documentoIdentidad = isset($_POST['participant_id']) ? trim($_POST['participant_id']) : null;
    $activityType    = isset($_POST['modalidad_deporte']) ? trim($_POST['modalidad_deporte']) : null;
    $attentionType   = isset($_POST['atencion_concentracion']) ? trim($_POST['atencion_concentracion']) : null;

    // Validación de los datos requeridos
    if (empty($participantName) || empty($activityType) || empty($attentionType)) {
        die(json_encode(['success' => false, 'message' => 'Faltan datos requeridos.']));
    }

    // Convertir el valor de atencion a entero para las comparaciones
    $attentionValue = (int)$attentionType;

// Convertir el valor de atención a entero para las comparaciones
    $attentionValue = (int)$attentionType;

    // Generar la recomendación basada en el valor de atención
    if ($attentionValue <= 5) {
        $recomendacion = "Mejora necesaria, se sugiere fuertemente poner mucho empeño en la realizacion de la actividad fisica para mejorar estas habilidades cognitivas evaluadas en el test.";
    } elseif ($attentionValue <= 10) {
        $recomendacion = "Atención adecuada, continúe trabajando en la actividad física para fortalecer sus habilidades cognitivas.";
    } elseif ($attentionValue <= 15) {
        $recomendacion = "Excelente atencion, ¡Felicitaciones! Su desempeno demuestra un excelente trabajo en el programa de actividad fisica, lo que se refleja en sus habilidades cognitivas.";
    }
// Inserta los datos en la base de datos usando una consulta preparada
$sql = "INSERT INTO atencion_concentracion (participant_name, participant_id, modalidad_deporte, aciertos, recomendaciones )/**/
        VALUES (?, ?, ?, ?, ?)"; //

$stmt = $conn->prepare($sql);

if ($stmt) {
    $stmt->bind_param("sssss", $participantName, $documentoIdentidad, $activityType, $attentionType, $recomendacion ); //

    if ($stmt->execute()) {
            // Se muestran los resultados en HTML
            ?>
            <!DOCTYPE html>
            <html lang="es">
            <head>
                <meta charset="UTF-8">
                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                <title>Resumen del Test de Atención y Concentración</title>
                <!--style>
                    .test-summary-container {
                        border: 1px solid #ccc;
                        padding: 20px;
                        margin-top: 20px;
                        border-radius: 10px;
                        background-color: #f9f9f9;
                    }
                    .summary-title {
                        font-size: 1.5em;
                        margin-bottom: 10px;
                    }
                    .summary-box {
                        font-size: 1em;
                        line-height: 1.5;
                    }
                </style-->
            </head>
            <body>
                <div class="test-summary-container">
                    <h3 class="summary-title">Resumen del Test de Atención y Concentración</h3>
                    <div class="summary-box">
                        <p><strong>Nombre del participante:</strong> <?php echo htmlspecialchars($participantName); ?></p>
                        <p><strong>Modalidad deportiva:</strong> <?php echo htmlspecialchars($activityType); ?></p>
                        <p><strong>Tiempo de atención y concentración:</strong> <?php echo htmlspecialchars($attentionType) . ' minutos'; ?></p>
                        <p><strong>Recomendación:</strong> <?php echo $recomendacion; ?></p>
                    </div>
                </div>
            </body>
            </html>
            <?php

            include "styleres.css";

        } else {
            die(json_encode(['success' => false, 'message' => 'Error al guardar los datos en la base de datos.']));
        }

        $stmt->close();
    } else {
        die(json_encode(['success' => false, 'message' => 'Error al preparar la consulta.']));
    }
}

$conn->close();
?>