<?php
// archivo save_results_matematicas_basicas.php
// Incluir archivo de configuración de la base de datos
require_once 'db_config.php';

// Habilitar reporte de errores
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Establecer cabeceras para JSON
header('Content-Type: application/json');

// Leer datos de la solicitud
$input = file_get_contents('php://input');
$data = json_decode($input, true);

// Verificar si los datos fueron recibidos
if (!$data) {
    echo json_encode(['status' => 'error', 'message' => 'No se recibieron datos válidos.']);
    exit;
}

// Extraer datos del arreglo recibido
$participant_name = $data['participant_name'] ?? null;
$participant_id = $data['participant_id'] ?? null;
$modalidad_deporte = $data['modalidad_deporte'] ?? null;
$totalQuestions = $data['totalQuestions'] ?? null;
$score = $data['score'] ?? null;
$responses = json_encode($data['responses']);
$correct_answers = json_encode($data['correct_answers']);
$operation = $data['operation'] ?? null;

// Verificar que todos los campos sean válidos
if (!$participant_name || !$participant_id || !$operation) {
    echo json_encode(['status' => 'error', 'message' => 'Faltan datos importantes.']);
    exit;
}


// Verificar si ya existe un registro previo
    $queryCheck = "SELECT * FROM matematicas_basicas WHERE participant_id = ? ORDER BY fecha_registro DESC LIMIT 1";
    $stmtCheck = $conn->prepare($queryCheck);
    $stmtCheck->bind_param("s", $documentoIdentidad);
    $stmtCheck->execute();
    $resultCheck = $stmtCheck->get_result();
    $isFollowUp = $resultCheck->num_rows > 0;

    $description = '';
    $recommendation = '';
    if ($isFollowUp) {
        // Comparación con el test anterior
        $lastEntry = $resultCheck->fetch_assoc();
        if ($score > $lastEntry['aciertos']) {
            $description = "Comparativamente con el test anterior de matemáticas básicas, hubo una mejoría.";
        } elseif ($score < $lastEntry['aciertos']) {
            $description = "Comparativamente con el test anterior de matemáticas básicas, hubo una disminución en el puntaje.";
        } else {
            $description = "Comparativamente con el test anterior de matemáticas básicas, los resultados permanecieron iguales.";
        }
    } else {
        $description = "El resultado obtenido en el test de matemáticas básicas, fue $score aciertos.";
    }

 // Determinar la apreciación.
  /*  if ($totalPuntaje >= ($totalOraciones * 4)) {
        $apreciacion = "Excelente desempeño. La operacio se realizó de manera correcta.";
    } elseif ($totalPuntaje >= ($totalOraciones * 3)) {
        $apreciacion = "Buena desempeño, pero podría mejorar.";
    } elseif ($totalPuntaje >= ($totalOraciones * 2)) {
        $apreciacion = "El desempeño tiene algunas deficiencias. Se recomienda practicar.";
    } else {
        $apreciacion = "Se requiere mejorar el desempeño. Intenta enfocarte más para la proxima oportunidad.";
    }

    return ['puntaje' => $totalPuntaje, 'apreciacion' => $apreciacion];
//}

$descripcion = $resultadoEvaluacion['apreciacion'];*/
// Generamos la recomendación basada en los aciertos
    $recommendations = $score >= 4 ? "Excelente desempeño, ¡Felicitaciones! Su desempeño demuestra un excelente trabajo en el programa de actividad física, lo que se refleja en sus habilidades cognitivas." : ($score >= 3 ? "Desempeño adecuado, Continúe trabajando en la actividad física para fortalecer sus habilidades cognitivas." : "Mejora necesaria, Se sugiere fuertemente poner mucho empeño en la realización de la actividad física con miras a mejorar estas habilidades cognitivas evaluadas en el test de matemáticas básicas.");
   /* // Generar recomendaciones solo si hay modalidad de deporte
    if ($score >= 3) {
        $recommendation = "¡Buen trabajo! Continúa practicando ejercicios para mantener y mejorar tu rendimiento.";
        if ($modalidad_deporte) {
            $recommendation .= " Además, puedes integrar ejercicios específicos relacionados con tu modalidad de deporte: $modalidad_deporte.";
        }
    } elseif ($modalidad_deporte) {
        $recommendation = "Considera integrar más ejercicios cognitivos y actividad física en tu rutina diaria. Además, puedes explorar nuevas actividades físicas que estimulen tu atención y procesamiento. También puedes probar ejercicios relacionados con tu modalidad de deporte.";
    } else {
        $recommendation = "Considera integrar más ejercicios cognitivos y actividad física en tu rutina diaria.";
    }*/
// Generar recomendaciones
/*$recommendations = '';
if (strtolower($modalidad_deporte) !== 'no participa de la investigacion') {
    switch ($modalidad_deporte) {
        case 'baja intensidad y equilibrio':
            $recommendations = "Te recomendamos continuar con ejercicios de baja intensidad y equilibrio para mejorar la salud cognitiva.";
            break;
        case 'resistencia moderada':
            $recommendations = "Los ejercicios de resistencia moderada pueden ayudarte a mejorar la salud cognitiva.";
            break;
        case 'aeróbicos adaptados':
            $recommendations = "Los ejercicios aeróbicos adaptados son beneficiosos para la salud cognitiva.";
            break;
        default:
            $recommendations = "Modalidad desconocida. Consulta con un especialista.";
    }
} else {
    $recommendations = "No hay recomendaciones sobre actividad física.";
}*/

// Preparar consulta SQL
$sql = "INSERT INTO matematicas_basicas (participant_name, participant_id, modalidad_deporte, tipo_operacion, score, total_preguntas, resultado,  recomendaciones)
        VALUES (?, ?, ?, ?, ?, ?, ?, ?)";

// Preparar la consulta
$stmt = $conn->prepare($sql);

// Vincular parámetros
$stmt->bind_param('ssssiiss', $participant_name, $participant_id, $modalidad_deporte, $operation, $score, $totalQuestions, $description, $recommendations);

// Ejecutar la consulta
if ($stmt->execute()) {
    echo json_encode(['status' => 'success', 'message' => 'Resultados guardados correctamente.']);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Error al guardar los resultados.']);
}

// Cerrar la conexión
//$stmt->close();
//$conn->close();
?>
<!-- Resumen del test para el usuario -->
<div class="test-summary-container">
    <h3 class="summary-title">Resumen del Test Matemáticas Básicas</h3>
    <div class="summary-box">
        <p><strong>Nombre del participante:</strong> <?= htmlspecialchars($participant_name) ?></p>
        <p><strong>Modalidad de actividad física:</strong> <?= htmlspecialchars($modalidad_deporte) ?></p>
        <p><strong>Puntaje obtenido:</strong> <?= $score ?> / <?= $totalQuestions ?></p>
        <p><strong>Recomendaciones:</strong> <?= htmlspecialchars($recommendations) ?></p>
    </div>
</div>
<?php
include "styleres.css";
?>