<?php
// archiv save_results_problemas.p

include 'db_config.php';
header('Content-Type: application/json');

// Obtener los datos enviados en el cuerpo de la solicitud
$data = json_decode(file_get_contents('php://input'), true);

$participantName = $data['userName'] ?? '';
$activityType = $data['activityType'] ?? '';
$category = $data['category'] ?? '';
$difficulty = $data['difficulty'] ?? '';
$score = $data['score'] ?? 0;
$totalProblems = $data['totalProblems'] ?? 0;
$timeTaken = $data['timeTaken'] ?? 0;

// Verificar que todos los datos requeridos estén presentes
if (empty($participantName) || empty($activityType) || empty($category) || empty($difficulty)) {
    echo json_encode(['success' => false, 'message' => 'Faltan datos requeridos.']);
    exit;
}

// Consulta para insertar los resultados en la tabla 'resolucion_problemas'
$sql = "INSERT INTO resolucion_problemas 
        (participant_name, modalidad_deporte, category, difficulty, score, total_problems, time_taken) 
        VALUES (?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ssssiii", $participantName, $activityType, $category, $difficulty, $score, $totalProblems, $timeTaken);

if ($stmt->execute()) {
    echo json_encode(['success' => true, 'message' => 'Resultados guardados correctamente.']);
} else {
    echo json_encode(['success' => false, 'message' => 'Error al guardar los datos: ' . $stmt->error]);
}

$stmt->close();
$conn->close();
?>

