<?php
// save_results_retencion.php
include 'db_config.php'; // Configuración de la base de datos

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Validar que las respuestas estén completas
    $respuestas = [];
    $aciertos = 0;

    for ($i = 0; $i < 5; $i++) {
        if (isset($_POST["respuesta$i"]) && isset($_POST["correcta$i"])) {
            $respuesta_usuario = strtolower(trim($_POST["respuesta$i"]));
            $respuesta_correcta = strtolower(trim($_POST["correcta$i"]));
            $respuestas[] = [
                'respuesta' => $respuesta_usuario,
                'correcta' => $respuesta_correcta
            ];

            // Incrementar aciertos si la respuesta es correcta
            if ($respuesta_usuario === $respuesta_correcta) {
                $aciertos++;
            }
        } else {
            die("Datos incompletos.");
        }
    }

    // Guardar resultados en la base de datos
$participant_name = isset($_POST['participant_name']) ? $_POST['participant_name'] : null;
$documentoIdentidad = isset($_POST['participant_id']) ? trim($_POST['participant_id']) : null;
$modalidad_deporte = isset($_POST['modalidad_deporte']) ? $_POST['modalidad_deporte'] : null;

// Generamos la recomendación basada en los aciertos
    $recomendacion = $aciertos >= 4 ? "Excelente retención, ¡Felicitaciones! Su desempeño demuestra un excelente trabajo en el programa de actividad física, lo que se refleja en sus habilidades cognitivas." : ($aciertos >= 3 ? "Retención adecuada, Continúe trabajando en la actividad física para fortalecer sus habilidades cognitivas." : "Mejora necesaria, Se sugiere fuertemente poner mucho empeño en la realización de la actividad física con miras a mejorar estas habilidades cognitivas evaluadas en el test.");

    $query = "
    INSERT INTO resultados_retencion (participant_name, participant_id, modalidad_deporte, aciertos, recomendacion)
    VALUES (?, ?, ?, ?, ?)";

    $stmt = $conn->prepare($query);
    $stmt->bind_param("sssis", $participant_name, $documentoIdentidad, $modalidad_deporte, $aciertos, $recomendacion);

    if ($stmt->execute()) {
        // Redirigir a la página de resumen con los resultados
        header("Location: resultados_retencion.php?id=" . $stmt->insert_id);
        exit(); // Asegurarse de que no se ejecute más código después de la redirección
    } else {
        echo json_encode(["success" => false, "message" => "Error al guardar los datos."]);
    }
}
?>
