const words = ["casa", "sol", "árbol", "libro", "flor"];
let attempt = 1;

function startTest() {
    document.getElementById("test-content").innerHTML = "";
    words.forEach((word) => {
        let wordElement = document.createElement("div");
        wordElement.innerHTML = `<p>${word}</p>`;
        document.getElementById("test-content").appendChild(wordElement);
    });
    document.getElementById("recollection-section").style.display = "block";
}

async function submitAttempt() {
    const participantId = document.getElementById("participant-id").value;
    const recalledWords = parseInt(document.getElementById("recalled-words").value);

    await fetch("/api/memory-test", {
        method: "POST",
        headers: {
            "Content-Type": "application/json",
        },
        body: JSON.stringify({
            participant_id: participantId,
            attempt: attempt,
            recalled_words: recalledWords
        })
    });

    attempt++;
    document.getElementById("recollection-section").style.display = "none";
    alert("Resultado del intento registrado.");
}

async function viewResults() {
    const participantId = document.getElementById("participant-id").value;
    const response = await fetch(`/api/memory-test/${participantId}`);
    const results = await response.json();

    let resultsHTML = "<h3>Resultados</h3><ul>";
    results.forEach(result => {
        resultsHTML += `<li>Intento ${result.attempt}: ${result.recalled_words} palabras recordadas</li>`;
    });
    resultsHTML += "</ul>";
    document.getElementById("results").innerHTML = resultsHTML;
}
