 document.addEventListener("DOMContentLoaded", () => {
    // Elementos interactivos
    const readingText = document.getElementById("reading-text");
    const readingQuestions = document.getElementById("reading-questions");
    const startReadingBtn = document.getElementById("start-reading");
    const submitReadingBtn = document.getElementById("submit-reading");
    const writingPrompt = document.getElementById("writing-prompt");
    const writingInput = document.getElementById("writing-input");
    const submitWritingBtn = document.getElementById("submit-writing");
    const resultsSection = document.getElementById("results-section");
    const resultsDisplay = document.getElementById("results-display");

    // Textos y preguntas para la prueba de lectura
    const textsWithQuestions = [
        {
            id: 1,
            text: "El sol brilla intensamente en el cielo mientras las hojas caen de los árboles.",
            questions: [
                { text: "¿Qué brilla intensamente en el cielo?", options: ["La luna", "El sol"], answer: "El sol" },
                { text: "¿Qué cae de los árboles?", options: ["Las hojas", "Las ramas"], answer: "Las hojas" }
            ]
        },
        {
            id: 2,
            text: "Los pájaros cantan por la mañana, llenando el aire de melodías.",
            questions: [
                { text: "¿Qué hacen los pájaros por la mañana?", options: ["Cantan", "Vuelan"], answer: "Cantan" },
                { text: "¿Qué llenan los pájaros con sus cantos?", options: ["El aire", "El cielo"], answer: "El aire" }
            ]
        },
        {
            id: 3,
            text: "El río fluye tranquilamente entre las montañas, reflejando el cielo azul.",
            questions: [
                { text: "¿Qué refleja el río?", options: ["Las montañas", "El cielo"], answer: "El cielo" },
                { text: "¿Dónde fluye el río?", options: ["Entre montañas", "Entre bosques"], answer: "Entre montañas" }
            ]
        },
        {
            id: 4,
            text: "El mercado local estaba lleno de frutas frescas y gente sonriendo mientras compraba.",
            questions: [
                { text: "¿Qué estaba lleno en el mercado?", options: ["Frutas frescas", "Verduras"], answer: "Frutas frescas" },
                { text: "¿Cómo estaba la gente?", options: ["Sonriendo", "Corriendo"], answer: "Sonriendo" }
            ]
        },
        {
            id: 5,
            text: "Un gato negro se escondía debajo de la mesa mientras observaba a los niños jugar.",
            questions: [
                { text: "¿Dónde se escondía el gato?", options: ["Debajo de la mesa", "Debajo de la cama"], answer: "Debajo de la mesa" },
                { text: "¿A quién observaba el gato?", options: ["A los niños", "A los perros"], answer: "A los niños" }
            ]
        },
        {
            id: 6,
            text: "En el parque, los niños corrían por el césped y jugaban con una pelota roja.",
            questions: [
                { text: "¿Dónde corrían los niños?", options: ["Por el césped", "Por la acera"], answer: "Por el césped" },
                { text: "¿Con qué jugaban los niños?", options: ["Una pelota roja", "Un frisbee"], answer: "Una pelota roja" }
            ]
        },
        {
            id: 7,
            text: "El tren llegó puntual a la estación, donde muchas personas esperaban con maletas.",
            questions: [
                { text: "¿Qué llegó puntual?", options: ["El tren", "El autobús"], answer: "El tren" },
                { text: "¿Qué tenían las personas?", options: ["Maletas", "Bicicletas"], answer: "Maletas" }
            ]
        },
        {
            id: 8,
            text: "El viento soplaba fuerte en la playa, levantando la arena hacia el cielo.",
            questions: [
                { text: "¿Dónde soplaba el viento?", options: ["En la playa", "En el bosque"], answer: "En la playa" },
                { text: "¿Qué levantaba el viento?", options: ["La arena", "Las hojas"], answer: "La arena" }
            ]
        },
        {
            id: 9,
            text: "La luna llena iluminaba el bosque, creando sombras en el suelo.",
            questions: [
                { text: "¿Qué iluminaba el bosque?", options: ["La luna llena", "Las estrellas"], answer: "La luna llena" },
                { text: "¿Qué se creaba en el suelo?", options: ["Sombras", "Luces"], answer: "Sombras" }
            ]
        },
        {
            id: 10,
            text: "El granjero recolectaba zanahorias mientras el perro corría entre los surcos.",
            questions: [
                { text: "¿Qué recolectaba el granjero?", options: ["Zanahorias", "Maíz"], answer: "Zanahorias" },
                { text: "¿Qué hacía el perro?", options: ["Corría", "Dormía"], answer: "Corría" }
            ]
        },
        {
            id: 11,
            text: "Un barco navegaba en el horizonte, desapareciendo lentamente tras las olas.",
            questions: [
                { text: "¿Dónde navegaba el barco?", options: ["En el horizonte", "En el puerto"], answer: "En el horizonte" },
                { text: "¿Qué lo cubría lentamente?", options: ["Las olas", "Las nubes"], answer: "Las olas" }
            ]
        },
        {
            id: 12,
            text: "El aroma del pan recién horneado llenaba la pequeña panadería en la mañana.",
            questions: [
                { text: "¿Qué llenaba la panadería?", options: ["El aroma del pan", "El aroma del café"], answer: "El aroma del pan" },
                { text: "¿Cuándo ocurría esto?", options: ["En la mañana", "En la noche"], answer: "En la mañana" }
            ]
        }
    ];

    


    // Variable para almacenar las preguntas actuales
    let currentQuestions = [];

    // Función para cargar texto de lectura y preguntas asociadas
    function loadReadingText() {
        const randomData = textsWithQuestions[Math.floor(Math.random() * textsWithQuestions.length)];
        readingText.innerText = randomData.text; // Muestra el texto
        loadReadingQuestions(randomData.questions); // Carga preguntas
        currentQuestions = randomData.questions; // Guarda preguntas actuales
        startReadingBtn.style.display = "none";
        submitReadingBtn.style.display = "block";
    }

    // Función para cargar preguntas
    function loadReadingQuestions(questions) {
        readingQuestions.innerHTML = questions.map((q, index) => `
            <div>
                <p>${q.text}</p>
                ${q.options.map(option => `
                    <label>
                        <input type="radio" name="question${index}" value="${option}"> ${option}
                    </label>
                `).join("")}
            </div>
        `).join("");
    }

    // Función para cargar tema de escritura
    function loadWritingPrompt() {
        const randomPrompt = prompts[Math.floor(Math.random() * prompts.length)];
        writingPrompt.innerText = randomPrompt;
    }

    // Función para mostrar resultados
    function showResults(results) {
        resultsSection.style.display = "block";
        resultsDisplay.innerHTML = `
            <p><strong>Resultados de lectura y comprención:</strong> ${results.reading}</p>
            
        `;
    }

    // Eventos
    startReadingBtn.addEventListener("click", loadReadingText);

    submitReadingBtn.addEventListener("click", () => {
        const answers = [...document.querySelectorAll("input[type='radio']:checked")];
        const correctAnswers = answers.filter((answer, index) => answer.value === currentQuestions[index].answer).length;
        const totalQuestions = currentQuestions.length;
        showResults({ reading: `Respuestas correctas: ${correctAnswers}/${totalQuestions}`});
    });


    // Inicializa la aplicación cargando un tema de escritura
    loadWritingPrompt();
});
